/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicaSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotAliasReplicaSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotAliasReplicasResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotAliasReplicasResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotAliasReplicasResponse.getter(ListBotAliasReplicasResponse::botId)).setter(ListBotAliasReplicasResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRegion").getter(ListBotAliasReplicasResponse.getter(ListBotAliasReplicasResponse::sourceRegion)).setter(ListBotAliasReplicasResponse.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()}).build();
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicaRegion").getter(ListBotAliasReplicasResponse.getter(ListBotAliasReplicasResponse::replicaRegion)).setter(ListBotAliasReplicasResponse.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()}).build();
    private static final SdkField<List<BotAliasReplicaSummary>> BOT_ALIAS_REPLICA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botAliasReplicaSummaries").getter(ListBotAliasReplicasResponse.getter(ListBotAliasReplicasResponse::botAliasReplicaSummaries)).setter(ListBotAliasReplicasResponse.setter(Builder::botAliasReplicaSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasReplicaSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotAliasReplicaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotAliasReplicasResponse.getter(ListBotAliasReplicasResponse::nextToken)).setter(ListBotAliasReplicasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, SOURCE_REGION_FIELD, REPLICA_REGION_FIELD, BOT_ALIAS_REPLICA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBotAliasReplicasResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String sourceRegion;
    private final String replicaRegion;
    private final List<BotAliasReplicaSummary> botAliasReplicaSummaries;
    private final String nextToken;

    private ListBotAliasReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.sourceRegion = builder.sourceRegion;
        this.replicaRegion = builder.replicaRegion;
        this.botAliasReplicaSummaries = builder.botAliasReplicaSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final boolean hasBotAliasReplicaSummaries() {
        return this.botAliasReplicaSummaries != null && !(this.botAliasReplicaSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotAliasReplicaSummary> botAliasReplicaSummaries() {
        return this.botAliasReplicaSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotAliasReplicaSummaries() ? this.botAliasReplicaSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotAliasReplicasResponse)) {
            return false;
        }
        ListBotAliasReplicasResponse other = (ListBotAliasReplicasResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.replicaRegion(), other.replicaRegion()) && this.hasBotAliasReplicaSummaries() == other.hasBotAliasReplicaSummaries() && Objects.equals(this.botAliasReplicaSummaries(), other.botAliasReplicaSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotAliasReplicasResponse").add("BotId", (Object)this.botId()).add("SourceRegion", (Object)this.sourceRegion()).add("ReplicaRegion", (Object)this.replicaRegion()).add("BotAliasReplicaSummaries", this.hasBotAliasReplicaSummaries() ? this.botAliasReplicaSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "sourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "replicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "botAliasReplicaSummaries": {
                return Optional.ofNullable(clazz.cast(this.botAliasReplicaSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("sourceRegion", SOURCE_REGION_FIELD);
        map.put("replicaRegion", REPLICA_REGION_FIELD);
        map.put("botAliasReplicaSummaries", BOT_ALIAS_REPLICA_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotAliasReplicasResponse, T> g) {
        return obj -> g.apply((ListBotAliasReplicasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String sourceRegion;
        private String replicaRegion;
        private List<BotAliasReplicaSummary> botAliasReplicaSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotAliasReplicasResponse model) {
            super(model);
            this.botId(model.botId);
            this.sourceRegion(model.sourceRegion);
            this.replicaRegion(model.replicaRegion);
            this.botAliasReplicaSummaries(model.botAliasReplicaSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final List<BotAliasReplicaSummary.Builder> getBotAliasReplicaSummaries() {
            List<BotAliasReplicaSummary.Builder> result = BotAliasReplicaSummaryListCopier.copyToBuilder(this.botAliasReplicaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotAliasReplicaSummaries(Collection<BotAliasReplicaSummary.BuilderImpl> botAliasReplicaSummaries) {
            this.botAliasReplicaSummaries = BotAliasReplicaSummaryListCopier.copyFromBuilder(botAliasReplicaSummaries);
        }

        @Override
        public final Builder botAliasReplicaSummaries(Collection<BotAliasReplicaSummary> botAliasReplicaSummaries) {
            this.botAliasReplicaSummaries = BotAliasReplicaSummaryListCopier.copy(botAliasReplicaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasReplicaSummaries(BotAliasReplicaSummary ... botAliasReplicaSummaries) {
            this.botAliasReplicaSummaries(Arrays.asList(botAliasReplicaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliasReplicaSummaries(Consumer<BotAliasReplicaSummary.Builder> ... botAliasReplicaSummaries) {
            this.botAliasReplicaSummaries(Stream.of(botAliasReplicaSummaries).map(c -> (BotAliasReplicaSummary)((BotAliasReplicaSummary.Builder)BotAliasReplicaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotAliasReplicasResponse build() {
            return new ListBotAliasReplicasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotAliasReplicasResponse> {
        public Builder botId(String var1);

        public Builder sourceRegion(String var1);

        public Builder replicaRegion(String var1);

        public Builder botAliasReplicaSummaries(Collection<BotAliasReplicaSummary> var1);

        public Builder botAliasReplicaSummaries(BotAliasReplicaSummary ... var1);

        public Builder botAliasReplicaSummaries(Consumer<BotAliasReplicaSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

