/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lexruntime.LexRuntimeClient;
import software.amazon.awssdk.services.lexruntime.LexRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntime.internal.LexRuntimeServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lexruntime.model.BadGatewayException;
import software.amazon.awssdk.services.lexruntime.model.BadRequestException;
import software.amazon.awssdk.services.lexruntime.model.ConflictException;
import software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.DependencyFailedException;
import software.amazon.awssdk.services.lexruntime.model.GetSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.GetSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.InternalFailureException;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeException;
import software.amazon.awssdk.services.lexruntime.model.LimitExceededException;
import software.amazon.awssdk.services.lexruntime.model.LoopDetectedException;
import software.amazon.awssdk.services.lexruntime.model.NotAcceptableException;
import software.amazon.awssdk.services.lexruntime.model.NotFoundException;
import software.amazon.awssdk.services.lexruntime.model.PostContentRequest;
import software.amazon.awssdk.services.lexruntime.model.PostContentResponse;
import software.amazon.awssdk.services.lexruntime.model.PostTextRequest;
import software.amazon.awssdk.services.lexruntime.model.PostTextResponse;
import software.amazon.awssdk.services.lexruntime.model.PutSessionRequest;
import software.amazon.awssdk.services.lexruntime.model.PutSessionResponse;
import software.amazon.awssdk.services.lexruntime.model.RequestTimeoutException;
import software.amazon.awssdk.services.lexruntime.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lexruntime.transform.DeleteSessionRequestMarshaller;
import software.amazon.awssdk.services.lexruntime.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.lexruntime.transform.PostContentRequestMarshaller;
import software.amazon.awssdk.services.lexruntime.transform.PostTextRequestMarshaller;
import software.amazon.awssdk.services.lexruntime.transform.PutSessionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLexRuntimeClient
implements LexRuntimeClient {
    private static final Logger log = Logger.loggerFor(DefaultLexRuntimeClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLexRuntimeClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Lex_Runtime_Service#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSessionResponse deleteSession(DeleteSessionRequest deleteSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException, LexRuntimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "DependencyFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(DependencyFailedException::builder).build());
                }
                case "UnsupportedMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException").httpStatusCode(Integer.valueOf(415)).exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).build());
                }
                case "NotAcceptableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAcceptableException").httpStatusCode(Integer.valueOf(406)).exceptionBuilderSupplier(NotAcceptableException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "LoopDetectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LoopDetectedException").httpStatusCode(Integer.valueOf(508)).exceptionBuilderSupplier(LoopDetectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLexRuntimeClient.resolveMetricPublishers(clientConfiguration, deleteSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Runtime Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSession");
            DeleteSessionResponse deleteSessionResponse = (DeleteSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexRuntimeClient.lambda$deleteSession$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, LexRuntimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "DependencyFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(DependencyFailedException::builder).build());
                }
                case "UnsupportedMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException").httpStatusCode(Integer.valueOf(415)).exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).build());
                }
                case "NotAcceptableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAcceptableException").httpStatusCode(Integer.valueOf(406)).exceptionBuilderSupplier(NotAcceptableException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "LoopDetectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LoopDetectedException").httpStatusCode(Integer.valueOf(508)).exceptionBuilderSupplier(LoopDetectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLexRuntimeClient.resolveMetricPublishers(clientConfiguration, getSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Runtime Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSession");
            GetSessionResponse getSessionResponse = (GetSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexRuntimeClient.lambda$getSession$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT postContent(PostContentRequest postContentRequest, RequestBody requestBody, ResponseTransformer<PostContentResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, UnsupportedMediaTypeException, NotAcceptableException, RequestTimeoutException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "DependencyFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(DependencyFailedException::builder).build());
                }
                case "UnsupportedMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException").httpStatusCode(Integer.valueOf(415)).exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).build());
                }
                case "NotAcceptableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAcceptableException").httpStatusCode(Integer.valueOf(406)).exceptionBuilderSupplier(NotAcceptableException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "LoopDetectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LoopDetectedException").httpStatusCode(Integer.valueOf(508)).exceptionBuilderSupplier(LoopDetectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)postContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLexRuntimeClient.resolveMetricPublishers(clientConfiguration, postContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Runtime Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostContent");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostContent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)postContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new PostContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).transferEncoding(true)).build()), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexRuntimeClient.lambda$postContent$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PostTextResponse postText(PostTextRequest postTextRequest) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, DependencyFailedException, BadGatewayException, LoopDetectedException, AwsServiceException, SdkClientException, LexRuntimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostTextResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "DependencyFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(DependencyFailedException::builder).build());
                }
                case "UnsupportedMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException").httpStatusCode(Integer.valueOf(415)).exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).build());
                }
                case "NotAcceptableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAcceptableException").httpStatusCode(Integer.valueOf(406)).exceptionBuilderSupplier(NotAcceptableException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "LoopDetectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LoopDetectedException").httpStatusCode(Integer.valueOf(508)).exceptionBuilderSupplier(LoopDetectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)postTextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLexRuntimeClient.resolveMetricPublishers(clientConfiguration, postTextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Runtime Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostText");
            PostTextResponse postTextResponse = (PostTextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostText").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)postTextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PostTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return postTextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexRuntimeClient.lambda$postText$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT putSession(PutSessionRequest putSessionRequest, ResponseTransformer<PutSessionResponse, ReturnT> responseTransformer) throws NotFoundException, BadRequestException, LimitExceededException, InternalFailureException, ConflictException, NotAcceptableException, DependencyFailedException, BadGatewayException, AwsServiceException, SdkClientException, LexRuntimeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "DependencyFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyFailedException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(DependencyFailedException::builder).build());
                }
                case "UnsupportedMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException").httpStatusCode(Integer.valueOf(415)).exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).build());
                }
                case "NotAcceptableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAcceptableException").httpStatusCode(Integer.valueOf(406)).exceptionBuilderSupplier(NotAcceptableException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "LoopDetectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LoopDetectedException").httpStatusCode(Integer.valueOf(508)).exceptionBuilderSupplier(LoopDetectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLexRuntimeClient.resolveMetricPublishers(clientConfiguration, putSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Runtime Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSession");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller((Marshaller)new PutSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexRuntimeClient.lambda$putSession$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "lex";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        LexRuntimeServiceClientConfigurationBuilder serviceConfigBuilder = new LexRuntimeServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LexRuntimeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final LexRuntimeServiceClientConfiguration serviceClientConfiguration() {
        return new LexRuntimeServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putSession$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postText$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postContent$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSession$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSession$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

