/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntimev2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You can provide Amazon Lex V2 with hints to the phrases that a customer is likely to use for a slot. When a slot with
 * hints is resolved, the phrases in the runtime hints are preferred in the resolution. You can provide hints for a
 * maximum of 100 intents. You can provide a maximum of 100 slots.
 * </p>
 * <p>
 * Before you can use runtime hints with an existing bot, you must first rebuild the bot.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml">Using hints to
 * improve accuracy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeHints implements SdkPojo, Serializable, ToCopyableBuilder<RuntimeHints.Builder, RuntimeHints> {
    private static final SdkField<Map<String, Map<String, RuntimeHintDetails>>> SLOT_HINTS_FIELD = SdkField
            .<Map<String, Map<String, RuntimeHintDetails>>> builder(MarshallingType.MAP)
            .memberName("slotHints")
            .getter(getter(RuntimeHints::slotHints))
            .setter(setter(Builder::slotHints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotHints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, RuntimeHintDetails>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<RuntimeHintDetails> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(RuntimeHintDetails::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_HINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Map<String, RuntimeHintDetails>> slotHints;

    private RuntimeHints(BuilderImpl builder) {
        this.slotHints = builder.slotHints;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotHints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSlotHints() {
        return slotHints != null && !(slotHints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the slots in the intent that should have runtime hints added, and the phrases that should be added for
     * each slot.
     * </p>
     * <p>
     * The first level of the <code>slotHints</code> map is the name of the intent. The second level is the name of the
     * slot within the intent. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml">Using hints to improve accuracy</a>.
     * </p>
     * <p>
     * The intent name and slot name must exist.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotHints} method.
     * </p>
     * 
     * @return A list of the slots in the intent that should have runtime hints added, and the phrases that should be
     *         added for each slot.</p>
     *         <p>
     *         The first level of the <code>slotHints</code> map is the name of the intent. The second level is the name
     *         of the slot within the intent. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml">Using hints to improve accuracy</a>.
     *         </p>
     *         <p>
     *         The intent name and slot name must exist.
     */
    public final Map<String, Map<String, RuntimeHintDetails>> slotHints() {
        return slotHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotHints() ? slotHints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeHints)) {
            return false;
        }
        RuntimeHints other = (RuntimeHints) obj;
        return hasSlotHints() == other.hasSlotHints() && Objects.equals(slotHints(), other.slotHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeHints").add("SlotHints", hasSlotHints() ? slotHints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotHints":
            return Optional.ofNullable(clazz.cast(slotHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeHints, T> g) {
        return obj -> g.apply((RuntimeHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeHints> {
        /**
         * <p>
         * A list of the slots in the intent that should have runtime hints added, and the phrases that should be added
         * for each slot.
         * </p>
         * <p>
         * The first level of the <code>slotHints</code> map is the name of the intent. The second level is the name of
         * the slot within the intent. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml">Using hints to improve accuracy</a>.
         * </p>
         * <p>
         * The intent name and slot name must exist.
         * </p>
         * 
         * @param slotHints
         *        A list of the slots in the intent that should have runtime hints added, and the phrases that should be
         *        added for each slot.</p>
         *        <p>
         *        The first level of the <code>slotHints</code> map is the name of the intent. The second level is the
         *        name of the slot within the intent. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.xml">Using hints to improve
         *        accuracy</a>.
         *        </p>
         *        <p>
         *        The intent name and slot name must exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotHints(Map<String, ? extends Map<String, RuntimeHintDetails>> slotHints);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Map<String, RuntimeHintDetails>> slotHints = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeHints model) {
            slotHints(model.slotHints);
        }

        public final Map<String, Map<String, RuntimeHintDetails.Builder>> getSlotHints() {
            Map<String, Map<String, RuntimeHintDetails.Builder>> result = SlotHintsIntentMapCopier.copyToBuilder(this.slotHints);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSlotHints(Map<String, ? extends Map<String, RuntimeHintDetails.BuilderImpl>> slotHints) {
            this.slotHints = SlotHintsIntentMapCopier.copyFromBuilder(slotHints);
        }

        @Override
        @Transient
        public final Builder slotHints(Map<String, ? extends Map<String, RuntimeHintDetails>> slotHints) {
            this.slotHints = SlotHintsIntentMapCopier.copy(slotHints);
            return this;
        }

        @Override
        public RuntimeHints build() {
            return new RuntimeHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
