/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperation;
import software.amazon.awssdk.services.licensemanager.model.AllowedOperationListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.PrincipalArnListCopier;
import software.amazon.awssdk.services.licensemanager.model.Tag;
import software.amazon.awssdk.services.licensemanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGrantRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateGrantRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateGrantRequest.getter(CreateGrantRequest::clientToken)).setter(CreateGrantRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> GRANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantName").getter(CreateGrantRequest.getter(CreateGrantRequest::grantName)).setter(CreateGrantRequest.setter(Builder::grantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantName").build()}).build();
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CreateGrantRequest.getter(CreateGrantRequest::licenseArn)).setter(CreateGrantRequest.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(CreateGrantRequest.getter(CreateGrantRequest::principals)).setter(CreateGrantRequest.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(CreateGrantRequest.getter(CreateGrantRequest::homeRegion)).setter(CreateGrantRequest.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<List<String>> ALLOWED_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedOperations").getter(CreateGrantRequest.getter(CreateGrantRequest::allowedOperationsAsStrings)).setter(CreateGrantRequest.setter(Builder::allowedOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateGrantRequest.getter(CreateGrantRequest::tags)).setter(CreateGrantRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, GRANT_NAME_FIELD, LICENSE_ARN_FIELD, PRINCIPALS_FIELD, HOME_REGION_FIELD, ALLOWED_OPERATIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGrantRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String grantName;
    private final String licenseArn;
    private final List<String> principals;
    private final String homeRegion;
    private final List<String> allowedOperations;
    private final List<Tag> tags;

    private CreateGrantRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.grantName = builder.grantName;
        this.licenseArn = builder.licenseArn;
        this.principals = builder.principals;
        this.homeRegion = builder.homeRegion;
        this.allowedOperations = builder.allowedOperations;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String grantName() {
        return this.grantName;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<String> principals() {
        return this.principals;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final List<AllowedOperation> allowedOperations() {
        return AllowedOperationListCopier.copyStringToEnum(this.allowedOperations);
    }

    public final boolean hasAllowedOperations() {
        return this.allowedOperations != null && !(this.allowedOperations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOperationsAsStrings() {
        return this.allowedOperations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOperations() ? this.allowedOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.grantName(), other.grantName()) && Objects.equals(this.licenseArn(), other.licenseArn()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.homeRegion(), other.homeRegion()) && this.hasAllowedOperations() == other.hasAllowedOperations() && Objects.equals(this.allowedOperationsAsStrings(), other.allowedOperationsAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGrantRequest").add("ClientToken", (Object)this.clientToken()).add("GrantName", (Object)this.grantName()).add("LicenseArn", (Object)this.licenseArn()).add("Principals", this.hasPrincipals() ? this.principals() : null).add("HomeRegion", (Object)this.homeRegion()).add("AllowedOperations", this.hasAllowedOperations() ? this.allowedOperationsAsStrings() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "GrantName": {
                return Optional.ofNullable(clazz.cast(this.grantName()));
            }
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "AllowedOperations": {
                return Optional.ofNullable(clazz.cast(this.allowedOperationsAsStrings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("GrantName", GRANT_NAME_FIELD);
        map.put("LicenseArn", LICENSE_ARN_FIELD);
        map.put("Principals", PRINCIPALS_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("AllowedOperations", ALLOWED_OPERATIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantRequest, T> g) {
        return obj -> g.apply((CreateGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String grantName;
        private String licenseArn;
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();
        private String homeRegion;
        private List<String> allowedOperations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.grantName(model.grantName);
            this.licenseArn(model.licenseArn);
            this.principals(model.principals);
            this.homeRegion(model.homeRegion);
            this.allowedOperationsWithStrings(model.allowedOperations);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGrantName() {
            return this.grantName;
        }

        public final void setGrantName(String grantName) {
            this.grantName = grantName;
        }

        @Override
        public final Builder grantName(String grantName) {
            this.grantName = grantName;
            return this;
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final Collection<String> getPrincipals() {
            if (this.principals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principals;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnListCopier.copy(principals);
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Collection<String> getAllowedOperations() {
            if (this.allowedOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOperations;
        }

        public final void setAllowedOperations(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
        }

        @Override
        public final Builder allowedOperationsWithStrings(Collection<String> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copy(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperationsWithStrings(String ... allowedOperations) {
            this.allowedOperationsWithStrings(Arrays.asList(allowedOperations));
            return this;
        }

        @Override
        public final Builder allowedOperations(Collection<AllowedOperation> allowedOperations) {
            this.allowedOperations = AllowedOperationListCopier.copyEnumToString(allowedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOperations(AllowedOperation ... allowedOperations) {
            this.allowedOperations(Arrays.asList(allowedOperations));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGrantRequest build() {
            return new CreateGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGrantRequest> {
        public Builder clientToken(String var1);

        public Builder grantName(String var1);

        public Builder licenseArn(String var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder homeRegion(String var1);

        public Builder allowedOperationsWithStrings(Collection<String> var1);

        public Builder allowedOperationsWithStrings(String ... var1);

        public Builder allowedOperations(Collection<AllowedOperation> var1);

        public Builder allowedOperations(AllowedOperation ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

