/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetsForLicenseAssetGroupRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, ListAssetsForLicenseAssetGroupRequest> {
    private static final SdkField<String> LICENSE_ASSET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseAssetGroupArn").getter(ListAssetsForLicenseAssetGroupRequest.getter(ListAssetsForLicenseAssetGroupRequest::licenseAssetGroupArn)).setter(ListAssetsForLicenseAssetGroupRequest.setter(Builder::licenseAssetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroupArn").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetType").getter(ListAssetsForLicenseAssetGroupRequest.getter(ListAssetsForLicenseAssetGroupRequest::assetType)).setter(ListAssetsForLicenseAssetGroupRequest.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAssetsForLicenseAssetGroupRequest.getter(ListAssetsForLicenseAssetGroupRequest::maxResults)).setter(ListAssetsForLicenseAssetGroupRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssetsForLicenseAssetGroupRequest.getter(ListAssetsForLicenseAssetGroupRequest::nextToken)).setter(ListAssetsForLicenseAssetGroupRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ASSET_GROUP_ARN_FIELD, ASSET_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssetsForLicenseAssetGroupRequest.memberNameToFieldInitializer();
    private final String licenseAssetGroupArn;
    private final String assetType;
    private final Integer maxResults;
    private final String nextToken;

    private ListAssetsForLicenseAssetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.licenseAssetGroupArn = builder.licenseAssetGroupArn;
        this.assetType = builder.assetType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String licenseAssetGroupArn() {
        return this.licenseAssetGroupArn;
    }

    public final String assetType() {
        return this.assetType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAssetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsForLicenseAssetGroupRequest)) {
            return false;
        }
        ListAssetsForLicenseAssetGroupRequest other = (ListAssetsForLicenseAssetGroupRequest)((Object)obj);
        return Objects.equals(this.licenseAssetGroupArn(), other.licenseAssetGroupArn()) && Objects.equals(this.assetType(), other.assetType()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetsForLicenseAssetGroupRequest").add("LicenseAssetGroupArn", (Object)this.licenseAssetGroupArn()).add("AssetType", (Object)this.assetType()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseAssetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupArn()));
            }
            case "AssetType": {
                return Optional.ofNullable(clazz.cast(this.assetType()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseAssetGroupArn", LICENSE_ASSET_GROUP_ARN_FIELD);
        map.put("AssetType", ASSET_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetsForLicenseAssetGroupRequest, T> g) {
        return obj -> g.apply((ListAssetsForLicenseAssetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseAssetGroupArn;
        private String assetType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetsForLicenseAssetGroupRequest model) {
            super(model);
            this.licenseAssetGroupArn(model.licenseAssetGroupArn);
            this.assetType(model.assetType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getLicenseAssetGroupArn() {
            return this.licenseAssetGroupArn;
        }

        public final void setLicenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
        }

        @Override
        public final Builder licenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
            return this;
        }

        public final String getAssetType() {
            return this.assetType;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetsForLicenseAssetGroupRequest build() {
            return new ListAssetsForLicenseAssetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetsForLicenseAssetGroupRequest> {
        public Builder licenseAssetGroupArn(String var1);

        public Builder assetType(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

