/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportContext> {
    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseConfigurationArns").getter(ReportContext.getter(ReportContext::licenseConfigurationArns)).setter(ReportContext.setter(Builder::licenseConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LICENSE_ASSET_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseAssetGroupArns").getter(ReportContext.getter(ReportContext::licenseAssetGroupArns)).setter(ReportContext.setter(Builder::licenseAssetGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseAssetGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> REPORT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("reportStartDate").getter(ReportContext.getter(ReportContext::reportStartDate)).setter(ReportContext.setter(Builder::reportStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportStartDate").build()}).build();
    private static final SdkField<Instant> REPORT_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("reportEndDate").getter(ReportContext.getter(ReportContext::reportEndDate)).setter(ReportContext.setter(Builder::reportEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportEndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_ARNS_FIELD, LICENSE_ASSET_GROUP_ARNS_FIELD, REPORT_START_DATE_FIELD, REPORT_END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> licenseConfigurationArns;
    private final List<String> licenseAssetGroupArns;
    private final Instant reportStartDate;
    private final Instant reportEndDate;

    private ReportContext(BuilderImpl builder) {
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
        this.licenseAssetGroupArns = builder.licenseAssetGroupArns;
        this.reportStartDate = builder.reportStartDate;
        this.reportEndDate = builder.reportEndDate;
    }

    public final boolean hasLicenseConfigurationArns() {
        return this.licenseConfigurationArns != null && !(this.licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    public final List<String> licenseConfigurationArns() {
        return this.licenseConfigurationArns;
    }

    public final boolean hasLicenseAssetGroupArns() {
        return this.licenseAssetGroupArns != null && !(this.licenseAssetGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> licenseAssetGroupArns() {
        return this.licenseAssetGroupArns;
    }

    public final Instant reportStartDate() {
        return this.reportStartDate;
    }

    public final Instant reportEndDate() {
        return this.reportEndDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConfigurationArns() ? this.licenseConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseAssetGroupArns() ? this.licenseAssetGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportEndDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportContext)) {
            return false;
        }
        ReportContext other = (ReportContext)obj;
        return this.hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns() && Objects.equals(this.licenseConfigurationArns(), other.licenseConfigurationArns()) && this.hasLicenseAssetGroupArns() == other.hasLicenseAssetGroupArns() && Objects.equals(this.licenseAssetGroupArns(), other.licenseAssetGroupArns()) && Objects.equals(this.reportStartDate(), other.reportStartDate()) && Objects.equals(this.reportEndDate(), other.reportEndDate());
    }

    public final String toString() {
        return ToString.builder((String)"ReportContext").add("LicenseConfigurationArns", this.hasLicenseConfigurationArns() ? this.licenseConfigurationArns() : null).add("LicenseAssetGroupArns", this.hasLicenseAssetGroupArns() ? this.licenseAssetGroupArns() : null).add("ReportStartDate", (Object)this.reportStartDate()).add("ReportEndDate", (Object)this.reportEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "licenseConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArns()));
            }
            case "licenseAssetGroupArns": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupArns()));
            }
            case "reportStartDate": {
                return Optional.ofNullable(clazz.cast(this.reportStartDate()));
            }
            case "reportEndDate": {
                return Optional.ofNullable(clazz.cast(this.reportEndDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("licenseConfigurationArns", LICENSE_CONFIGURATION_ARNS_FIELD);
        map.put("licenseAssetGroupArns", LICENSE_ASSET_GROUP_ARNS_FIELD);
        map.put("reportStartDate", REPORT_START_DATE_FIELD);
        map.put("reportEndDate", REPORT_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportContext, T> g) {
        return obj -> g.apply((ReportContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> licenseAssetGroupArns = DefaultSdkAutoConstructList.getInstance();
        private Instant reportStartDate;
        private Instant reportEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportContext model) {
            this.licenseConfigurationArns(model.licenseConfigurationArns);
            this.licenseAssetGroupArns(model.licenseAssetGroupArns);
            this.reportStartDate(model.reportStartDate);
            this.reportEndDate(model.reportEndDate);
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (this.licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseConfigurationArns;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = ArnListCopier.copy(licenseConfigurationArns);
        }

        @Override
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = ArnListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationArns(String ... licenseConfigurationArns) {
            this.licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        public final Collection<String> getLicenseAssetGroupArns() {
            if (this.licenseAssetGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseAssetGroupArns;
        }

        public final void setLicenseAssetGroupArns(Collection<String> licenseAssetGroupArns) {
            this.licenseAssetGroupArns = ArnListCopier.copy(licenseAssetGroupArns);
        }

        @Override
        public final Builder licenseAssetGroupArns(Collection<String> licenseAssetGroupArns) {
            this.licenseAssetGroupArns = ArnListCopier.copy(licenseAssetGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroupArns(String ... licenseAssetGroupArns) {
            this.licenseAssetGroupArns(Arrays.asList(licenseAssetGroupArns));
            return this;
        }

        public final Instant getReportStartDate() {
            return this.reportStartDate;
        }

        public final void setReportStartDate(Instant reportStartDate) {
            this.reportStartDate = reportStartDate;
        }

        @Override
        public final Builder reportStartDate(Instant reportStartDate) {
            this.reportStartDate = reportStartDate;
            return this;
        }

        public final Instant getReportEndDate() {
            return this.reportEndDate;
        }

        public final void setReportEndDate(Instant reportEndDate) {
            this.reportEndDate = reportEndDate;
        }

        @Override
        public final Builder reportEndDate(Instant reportEndDate) {
            this.reportEndDate = reportEndDate;
            return this;
        }

        public ReportContext build() {
            return new ReportContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportContext> {
        public Builder licenseConfigurationArns(Collection<String> var1);

        public Builder licenseConfigurationArns(String ... var1);

        public Builder licenseAssetGroupArns(Collection<String> var1);

        public Builder licenseAssetGroupArns(String ... var1);

        public Builder reportStartDate(Instant var1);

        public Builder reportEndDate(Instant var1);
    }
}

