/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinuxSubscriptionsDiscoverySettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinuxSubscriptionsDiscoverySettings> {
    private static final SdkField<String> ORGANIZATION_INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationIntegration").getter(LinuxSubscriptionsDiscoverySettings.getter(LinuxSubscriptionsDiscoverySettings::organizationIntegrationAsString)).setter(LinuxSubscriptionsDiscoverySettings.setter(Builder::organizationIntegration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationIntegration").build()}).build();
    private static final SdkField<List<String>> SOURCE_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceRegions").getter(LinuxSubscriptionsDiscoverySettings.getter(LinuxSubscriptionsDiscoverySettings::sourceRegions)).setter(LinuxSubscriptionsDiscoverySettings.setter(Builder::sourceRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_INTEGRATION_FIELD, SOURCE_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LinuxSubscriptionsDiscoverySettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String organizationIntegration;
    private final List<String> sourceRegions;

    private LinuxSubscriptionsDiscoverySettings(BuilderImpl builder) {
        this.organizationIntegration = builder.organizationIntegration;
        this.sourceRegions = builder.sourceRegions;
    }

    public final OrganizationIntegration organizationIntegration() {
        return OrganizationIntegration.fromValue(this.organizationIntegration);
    }

    public final String organizationIntegrationAsString() {
        return this.organizationIntegration;
    }

    public final boolean hasSourceRegions() {
        return this.sourceRegions != null && !(this.sourceRegions instanceof SdkAutoConstructList);
    }

    public final List<String> sourceRegions() {
        return this.sourceRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationIntegrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceRegions() ? this.sourceRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinuxSubscriptionsDiscoverySettings)) {
            return false;
        }
        LinuxSubscriptionsDiscoverySettings other = (LinuxSubscriptionsDiscoverySettings)obj;
        return Objects.equals(this.organizationIntegrationAsString(), other.organizationIntegrationAsString()) && this.hasSourceRegions() == other.hasSourceRegions() && Objects.equals(this.sourceRegions(), other.sourceRegions());
    }

    public final String toString() {
        return ToString.builder((String)"LinuxSubscriptionsDiscoverySettings").add("OrganizationIntegration", (Object)this.organizationIntegrationAsString()).add("SourceRegions", this.hasSourceRegions() ? this.sourceRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationIntegration": {
                return Optional.ofNullable(clazz.cast(this.organizationIntegrationAsString()));
            }
            case "SourceRegions": {
                return Optional.ofNullable(clazz.cast(this.sourceRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationIntegration", ORGANIZATION_INTEGRATION_FIELD);
        map.put("SourceRegions", SOURCE_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinuxSubscriptionsDiscoverySettings, T> g) {
        return obj -> g.apply((LinuxSubscriptionsDiscoverySettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationIntegration;
        private List<String> sourceRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LinuxSubscriptionsDiscoverySettings model) {
            this.organizationIntegration(model.organizationIntegration);
            this.sourceRegions(model.sourceRegions);
        }

        public final String getOrganizationIntegration() {
            return this.organizationIntegration;
        }

        public final void setOrganizationIntegration(String organizationIntegration) {
            this.organizationIntegration = organizationIntegration;
        }

        @Override
        public final Builder organizationIntegration(String organizationIntegration) {
            this.organizationIntegration = organizationIntegration;
            return this;
        }

        @Override
        public final Builder organizationIntegration(OrganizationIntegration organizationIntegration) {
            this.organizationIntegration(organizationIntegration == null ? null : organizationIntegration.toString());
            return this;
        }

        public final Collection<String> getSourceRegions() {
            if (this.sourceRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceRegions;
        }

        public final void setSourceRegions(Collection<String> sourceRegions) {
            this.sourceRegions = StringListCopier.copy(sourceRegions);
        }

        @Override
        public final Builder sourceRegions(Collection<String> sourceRegions) {
            this.sourceRegions = StringListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(String ... sourceRegions) {
            this.sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        public LinuxSubscriptionsDiscoverySettings build() {
            return new LinuxSubscriptionsDiscoverySettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinuxSubscriptionsDiscoverySettings> {
        public Builder organizationIntegration(String var1);

        public Builder organizationIntegration(OrganizationIntegration var1);

        public Builder sourceRegions(Collection<String> var1);

        public Builder sourceRegions(String ... var1);
    }
}

