/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceSettingsRequest
extends LicenseManagerLinuxSubscriptionsRequest
implements ToCopyableBuilder<Builder, UpdateServiceSettingsRequest> {
    private static final SdkField<Boolean> ALLOW_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowUpdate").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::allowUpdate)).setter(UpdateServiceSettingsRequest.setter(Builder::allowUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUpdate").build()}).build();
    private static final SdkField<String> LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinuxSubscriptionsDiscovery").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::linuxSubscriptionsDiscoveryAsString)).setter(UpdateServiceSettingsRequest.setter(Builder::linuxSubscriptionsDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxSubscriptionsDiscovery").build()}).build();
    private static final SdkField<LinuxSubscriptionsDiscoverySettings> LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinuxSubscriptionsDiscoverySettings").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::linuxSubscriptionsDiscoverySettings)).setter(UpdateServiceSettingsRequest.setter(Builder::linuxSubscriptionsDiscoverySettings)).constructor(LinuxSubscriptionsDiscoverySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxSubscriptionsDiscoverySettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_UPDATE_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceSettingsRequest.memberNameToFieldInitializer();
    private final Boolean allowUpdate;
    private final String linuxSubscriptionsDiscovery;
    private final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;

    private UpdateServiceSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.allowUpdate = builder.allowUpdate;
        this.linuxSubscriptionsDiscovery = builder.linuxSubscriptionsDiscovery;
        this.linuxSubscriptionsDiscoverySettings = builder.linuxSubscriptionsDiscoverySettings;
    }

    public final Boolean allowUpdate() {
        return this.allowUpdate;
    }

    public final LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery() {
        return LinuxSubscriptionsDiscovery.fromValue(this.linuxSubscriptionsDiscovery);
    }

    public final String linuxSubscriptionsDiscoveryAsString() {
        return this.linuxSubscriptionsDiscovery;
    }

    public final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings() {
        return this.linuxSubscriptionsDiscoverySettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxSubscriptionsDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxSubscriptionsDiscoverySettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingsRequest)) {
            return false;
        }
        UpdateServiceSettingsRequest other = (UpdateServiceSettingsRequest)((Object)obj);
        return Objects.equals(this.allowUpdate(), other.allowUpdate()) && Objects.equals(this.linuxSubscriptionsDiscoveryAsString(), other.linuxSubscriptionsDiscoveryAsString()) && Objects.equals(this.linuxSubscriptionsDiscoverySettings(), other.linuxSubscriptionsDiscoverySettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceSettingsRequest").add("AllowUpdate", (Object)this.allowUpdate()).add("LinuxSubscriptionsDiscovery", (Object)this.linuxSubscriptionsDiscoveryAsString()).add("LinuxSubscriptionsDiscoverySettings", (Object)this.linuxSubscriptionsDiscoverySettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowUpdate": {
                return Optional.ofNullable(clazz.cast(this.allowUpdate()));
            }
            case "LinuxSubscriptionsDiscovery": {
                return Optional.ofNullable(clazz.cast(this.linuxSubscriptionsDiscoveryAsString()));
            }
            case "LinuxSubscriptionsDiscoverySettings": {
                return Optional.ofNullable(clazz.cast(this.linuxSubscriptionsDiscoverySettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllowUpdate", ALLOW_UPDATE_FIELD);
        map.put("LinuxSubscriptionsDiscovery", LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD);
        map.put("LinuxSubscriptionsDiscoverySettings", LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingsRequest, T> g) {
        return obj -> g.apply((UpdateServiceSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerLinuxSubscriptionsRequest.BuilderImpl
    implements Builder {
        private Boolean allowUpdate;
        private String linuxSubscriptionsDiscovery;
        private LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingsRequest model) {
            super(model);
            this.allowUpdate(model.allowUpdate);
            this.linuxSubscriptionsDiscovery(model.linuxSubscriptionsDiscovery);
            this.linuxSubscriptionsDiscoverySettings(model.linuxSubscriptionsDiscoverySettings);
        }

        public final Boolean getAllowUpdate() {
            return this.allowUpdate;
        }

        public final void setAllowUpdate(Boolean allowUpdate) {
            this.allowUpdate = allowUpdate;
        }

        @Override
        public final Builder allowUpdate(Boolean allowUpdate) {
            this.allowUpdate = allowUpdate;
            return this;
        }

        public final String getLinuxSubscriptionsDiscovery() {
            return this.linuxSubscriptionsDiscovery;
        }

        public final void setLinuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
            return this;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery(linuxSubscriptionsDiscovery == null ? null : linuxSubscriptionsDiscovery.toString());
            return this;
        }

        public final LinuxSubscriptionsDiscoverySettings.Builder getLinuxSubscriptionsDiscoverySettings() {
            return this.linuxSubscriptionsDiscoverySettings != null ? this.linuxSubscriptionsDiscoverySettings.toBuilder() : null;
        }

        public final void setLinuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings.BuilderImpl linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings != null ? linuxSubscriptionsDiscoverySettings.build() : null;
        }

        @Override
        public final Builder linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSettingsRequest build() {
            return new UpdateServiceSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerLinuxSubscriptionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceSettingsRequest> {
        public Builder allowUpdate(Boolean var1);

        public Builder linuxSubscriptionsDiscovery(String var1);

        public Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery var1);

        public Builder linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings var1);

        default public Builder linuxSubscriptionsDiscoverySettings(Consumer<LinuxSubscriptionsDiscoverySettings.Builder> linuxSubscriptionsDiscoverySettings) {
            return this.linuxSubscriptionsDiscoverySettings((LinuxSubscriptionsDiscoverySettings)((LinuxSubscriptionsDiscoverySettings.Builder)LinuxSubscriptionsDiscoverySettings.builder().applyMutation(linuxSubscriptionsDiscoverySettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

