/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerSettings;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseServerEndpointRequest
extends LicenseManagerUserSubscriptionsRequest
implements ToCopyableBuilder<Builder, CreateLicenseServerEndpointRequest> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderArn").getter(CreateLicenseServerEndpointRequest.getter(CreateLicenseServerEndpointRequest::identityProviderArn)).setter(CreateLicenseServerEndpointRequest.setter(Builder::identityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderArn").build()}).build();
    private static final SdkField<LicenseServerSettings> LICENSE_SERVER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LicenseServerSettings").getter(CreateLicenseServerEndpointRequest.getter(CreateLicenseServerEndpointRequest::licenseServerSettings)).setter(CreateLicenseServerEndpointRequest.setter(Builder::licenseServerSettings)).constructor(LicenseServerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseServerSettings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLicenseServerEndpointRequest.getter(CreateLicenseServerEndpointRequest::tags)).setter(CreateLicenseServerEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD, LICENSE_SERVER_SETTINGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLicenseServerEndpointRequest.memberNameToFieldInitializer();
    private final String identityProviderArn;
    private final LicenseServerSettings licenseServerSettings;
    private final Map<String, String> tags;

    private CreateLicenseServerEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.identityProviderArn = builder.identityProviderArn;
        this.licenseServerSettings = builder.licenseServerSettings;
        this.tags = builder.tags;
    }

    public final String identityProviderArn() {
        return this.identityProviderArn;
    }

    public final LicenseServerSettings licenseServerSettings() {
        return this.licenseServerSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseServerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseServerEndpointRequest)) {
            return false;
        }
        CreateLicenseServerEndpointRequest other = (CreateLicenseServerEndpointRequest)((Object)obj);
        return Objects.equals(this.identityProviderArn(), other.identityProviderArn()) && Objects.equals(this.licenseServerSettings(), other.licenseServerSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseServerEndpointRequest").add("IdentityProviderArn", (Object)this.identityProviderArn()).add("LicenseServerSettings", (Object)this.licenseServerSettings()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.identityProviderArn()));
            }
            case "LicenseServerSettings": {
                return Optional.ofNullable(clazz.cast(this.licenseServerSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
        map.put("LicenseServerSettings", LICENSE_SERVER_SETTINGS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseServerEndpointRequest, T> g) {
        return obj -> g.apply((CreateLicenseServerEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerUserSubscriptionsRequest.BuilderImpl
    implements Builder {
        private String identityProviderArn;
        private LicenseServerSettings licenseServerSettings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseServerEndpointRequest model) {
            super(model);
            this.identityProviderArn(model.identityProviderArn);
            this.licenseServerSettings(model.licenseServerSettings);
            this.tags(model.tags);
        }

        public final String getIdentityProviderArn() {
            return this.identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final LicenseServerSettings.Builder getLicenseServerSettings() {
            return this.licenseServerSettings != null ? this.licenseServerSettings.toBuilder() : null;
        }

        public final void setLicenseServerSettings(LicenseServerSettings.BuilderImpl licenseServerSettings) {
            this.licenseServerSettings = licenseServerSettings != null ? licenseServerSettings.build() : null;
        }

        @Override
        public final Builder licenseServerSettings(LicenseServerSettings licenseServerSettings) {
            this.licenseServerSettings = licenseServerSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseServerEndpointRequest build() {
            return new CreateLicenseServerEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerUserSubscriptionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseServerEndpointRequest> {
        public Builder identityProviderArn(String var1);

        public Builder licenseServerSettings(LicenseServerSettings var1);

        default public Builder licenseServerSettings(Consumer<LicenseServerSettings.Builder> licenseServerSettings) {
            return this.licenseServerSettings((LicenseServerSettings)((LicenseServerSettings.Builder)LicenseServerSettings.builder().applyMutation(licenseServerSettings)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

