/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEventListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerLogResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContainerLogResponse> {
    private static final SdkField<List<ContainerServiceLogEvent>> LOG_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logEvents").getter(GetContainerLogResponse.getter(GetContainerLogResponse::logEvents)).setter(GetContainerLogResponse.setter(Builder::logEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerServiceLogEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetContainerLogResponse.getter(GetContainerLogResponse::nextPageToken)).setter(GetContainerLogResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_EVENTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetContainerLogResponse.memberNameToFieldInitializer();
    private final List<ContainerServiceLogEvent> logEvents;
    private final String nextPageToken;

    private GetContainerLogResponse(BuilderImpl builder) {
        super(builder);
        this.logEvents = builder.logEvents;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasLogEvents() {
        return this.logEvents != null && !(this.logEvents instanceof SdkAutoConstructList);
    }

    public final List<ContainerServiceLogEvent> logEvents() {
        return this.logEvents;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogEvents() ? this.logEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerLogResponse)) {
            return false;
        }
        GetContainerLogResponse other = (GetContainerLogResponse)((Object)obj);
        return this.hasLogEvents() == other.hasLogEvents() && Objects.equals(this.logEvents(), other.logEvents()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerLogResponse").add("LogEvents", this.hasLogEvents() ? this.logEvents() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logEvents": {
                return Optional.ofNullable(clazz.cast(this.logEvents()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logEvents", LOG_EVENTS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContainerLogResponse, T> g) {
        return obj -> g.apply((GetContainerLogResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<ContainerServiceLogEvent> logEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerLogResponse model) {
            super(model);
            this.logEvents(model.logEvents);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<ContainerServiceLogEvent.Builder> getLogEvents() {
            List<ContainerServiceLogEvent.Builder> result = ContainerServiceLogEventListCopier.copyToBuilder(this.logEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogEvents(Collection<ContainerServiceLogEvent.BuilderImpl> logEvents) {
            this.logEvents = ContainerServiceLogEventListCopier.copyFromBuilder(logEvents);
        }

        @Override
        public final Builder logEvents(Collection<ContainerServiceLogEvent> logEvents) {
            this.logEvents = ContainerServiceLogEventListCopier.copy(logEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEvents(ContainerServiceLogEvent ... logEvents) {
            this.logEvents(Arrays.asList(logEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEvents(Consumer<ContainerServiceLogEvent.Builder> ... logEvents) {
            this.logEvents(Stream.of(logEvents).map(c -> (ContainerServiceLogEvent)((ContainerServiceLogEvent.Builder)ContainerServiceLogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetContainerLogResponse build() {
            return new GetContainerLogResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerLogResponse> {
        public Builder logEvents(Collection<ContainerServiceLogEvent> var1);

        public Builder logEvents(ContainerServiceLogEvent ... var1);

        public Builder logEvents(Consumer<ContainerServiceLogEvent.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

