/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DistributionMetricName {
    REQUESTS("Requests"),
    BYTES_DOWNLOADED("BytesDownloaded"),
    BYTES_UPLOADED("BytesUploaded"),
    TOTAL_ERROR_RATE("TotalErrorRate"),
    HTTP4_XX_ERROR_RATE("Http4xxErrorRate"),
    HTTP5_XX_ERROR_RATE("Http5xxErrorRate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DistributionMetricName> VALUE_MAP;
    private final String value;

    private DistributionMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DistributionMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DistributionMetricName> knownValues() {
        EnumSet<DistributionMetricName> knownValues = EnumSet.allOf(DistributionMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DistributionMetricName.class, DistributionMetricName::toString);
    }
}

