/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CacheBehavior;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorListCopier;
import software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath;
import software.amazon.awssdk.services.lightsail.model.CacheSettings;
import software.amazon.awssdk.services.lightsail.model.InputOrigin;
import software.amazon.awssdk.services.lightsail.model.IpAddressType;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDistributionRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateDistributionRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionName").getter(CreateDistributionRequest.getter(CreateDistributionRequest::distributionName)).setter(CreateDistributionRequest.setter(Builder::distributionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()}).build();
    private static final SdkField<InputOrigin> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("origin").getter(CreateDistributionRequest.getter(CreateDistributionRequest::origin)).setter(CreateDistributionRequest.setter(Builder::origin)).constructor(InputOrigin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()}).build();
    private static final SdkField<CacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultCacheBehavior").getter(CreateDistributionRequest.getter(CreateDistributionRequest::defaultCacheBehavior)).setter(CreateDistributionRequest.setter(Builder::defaultCacheBehavior)).constructor(CacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCacheBehavior").build()}).build();
    private static final SdkField<CacheSettings> CACHE_BEHAVIOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cacheBehaviorSettings").getter(CreateDistributionRequest.getter(CreateDistributionRequest::cacheBehaviorSettings)).setter(CreateDistributionRequest.setter(Builder::cacheBehaviorSettings)).constructor(CacheSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviorSettings").build()}).build();
    private static final SdkField<List<CacheBehaviorPerPath>> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheBehaviors").getter(CreateDistributionRequest.getter(CreateDistributionRequest::cacheBehaviors)).setter(CreateDistributionRequest.setter(Builder::cacheBehaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheBehaviorPerPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(CreateDistributionRequest.getter(CreateDistributionRequest::bundleId)).setter(CreateDistributionRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(CreateDistributionRequest.getter(CreateDistributionRequest::ipAddressTypeAsString)).setter(CreateDistributionRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDistributionRequest.getter(CreateDistributionRequest::tags)).setter(CreateDistributionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateName").getter(CreateDistributionRequest.getter(CreateDistributionRequest::certificateName)).setter(CreateDistributionRequest.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<String> VIEWER_MINIMUM_TLS_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("viewerMinimumTlsProtocolVersion").getter(CreateDistributionRequest.getter(CreateDistributionRequest::viewerMinimumTlsProtocolVersionAsString)).setter(CreateDistributionRequest.setter(Builder::viewerMinimumTlsProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerMinimumTlsProtocolVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD, ORIGIN_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIOR_SETTINGS_FIELD, CACHE_BEHAVIORS_FIELD, BUNDLE_ID_FIELD, IP_ADDRESS_TYPE_FIELD, TAGS_FIELD, CERTIFICATE_NAME_FIELD, VIEWER_MINIMUM_TLS_PROTOCOL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDistributionRequest.memberNameToFieldInitializer();
    private final String distributionName;
    private final InputOrigin origin;
    private final CacheBehavior defaultCacheBehavior;
    private final CacheSettings cacheBehaviorSettings;
    private final List<CacheBehaviorPerPath> cacheBehaviors;
    private final String bundleId;
    private final String ipAddressType;
    private final List<Tag> tags;
    private final String certificateName;
    private final String viewerMinimumTlsProtocolVersion;

    private CreateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.origin = builder.origin;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.bundleId = builder.bundleId;
        this.ipAddressType = builder.ipAddressType;
        this.tags = builder.tags;
        this.certificateName = builder.certificateName;
        this.viewerMinimumTlsProtocolVersion = builder.viewerMinimumTlsProtocolVersion;
    }

    public final String distributionName() {
        return this.distributionName;
    }

    public final InputOrigin origin() {
        return this.origin;
    }

    public final CacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public final CacheSettings cacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public final boolean hasCacheBehaviors() {
        return this.cacheBehaviors != null && !(this.cacheBehaviors instanceof SdkAutoConstructList);
    }

    public final List<CacheBehaviorPerPath> cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String certificateName() {
        return this.certificateName;
    }

    public final ViewerMinimumTlsProtocolVersionEnum viewerMinimumTlsProtocolVersion() {
        return ViewerMinimumTlsProtocolVersionEnum.fromValue(this.viewerMinimumTlsProtocolVersion);
    }

    public final String viewerMinimumTlsProtocolVersionAsString() {
        return this.viewerMinimumTlsProtocolVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheBehaviors() ? this.cacheBehaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerMinimumTlsProtocolVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionRequest)) {
            return false;
        }
        CreateDistributionRequest other = (CreateDistributionRequest)((Object)obj);
        return Objects.equals(this.distributionName(), other.distributionName()) && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviorSettings(), other.cacheBehaviorSettings()) && this.hasCacheBehaviors() == other.hasCacheBehaviors() && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.viewerMinimumTlsProtocolVersionAsString(), other.viewerMinimumTlsProtocolVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDistributionRequest").add("DistributionName", (Object)this.distributionName()).add("Origin", (Object)this.origin()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviorSettings", (Object)this.cacheBehaviorSettings()).add("CacheBehaviors", this.hasCacheBehaviors() ? this.cacheBehaviors() : null).add("BundleId", (Object)this.bundleId()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("CertificateName", (Object)this.certificateName()).add("ViewerMinimumTlsProtocolVersion", (Object)this.viewerMinimumTlsProtocolVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distributionName": {
                return Optional.ofNullable(clazz.cast(this.distributionName()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "defaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "cacheBehaviorSettings": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorSettings()));
            }
            case "cacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "viewerMinimumTlsProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.viewerMinimumTlsProtocolVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("distributionName", DISTRIBUTION_NAME_FIELD);
        map.put("origin", ORIGIN_FIELD);
        map.put("defaultCacheBehavior", DEFAULT_CACHE_BEHAVIOR_FIELD);
        map.put("cacheBehaviorSettings", CACHE_BEHAVIOR_SETTINGS_FIELD);
        map.put("cacheBehaviors", CACHE_BEHAVIORS_FIELD);
        map.put("bundleId", BUNDLE_ID_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("certificateName", CERTIFICATE_NAME_FIELD);
        map.put("viewerMinimumTlsProtocolVersion", VIEWER_MINIMUM_TLS_PROTOCOL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDistributionRequest, T> g) {
        return obj -> g.apply((CreateDistributionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String distributionName;
        private InputOrigin origin;
        private CacheBehavior defaultCacheBehavior;
        private CacheSettings cacheBehaviorSettings;
        private List<CacheBehaviorPerPath> cacheBehaviors = DefaultSdkAutoConstructList.getInstance();
        private String bundleId;
        private String ipAddressType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String certificateName;
        private String viewerMinimumTlsProtocolVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionRequest model) {
            super(model);
            this.distributionName(model.distributionName);
            this.origin(model.origin);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviorSettings(model.cacheBehaviorSettings);
            this.cacheBehaviors(model.cacheBehaviors);
            this.bundleId(model.bundleId);
            this.ipAddressType(model.ipAddressType);
            this.tags(model.tags);
            this.certificateName(model.certificateName);
            this.viewerMinimumTlsProtocolVersion(model.viewerMinimumTlsProtocolVersion);
        }

        public final String getDistributionName() {
            return this.distributionName;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final InputOrigin.Builder getOrigin() {
            return this.origin != null ? this.origin.toBuilder() : null;
        }

        public final void setOrigin(InputOrigin.BuilderImpl origin) {
            this.origin = origin != null ? origin.build() : null;
        }

        @Override
        public final Builder origin(InputOrigin origin) {
            this.origin = origin;
            return this;
        }

        public final CacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(CacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheSettings.Builder getCacheBehaviorSettings() {
            return this.cacheBehaviorSettings != null ? this.cacheBehaviorSettings.toBuilder() : null;
        }

        public final void setCacheBehaviorSettings(CacheSettings.BuilderImpl cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings != null ? cacheBehaviorSettings.build() : null;
        }

        @Override
        public final Builder cacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        public final List<CacheBehaviorPerPath.Builder> getCacheBehaviors() {
            List<CacheBehaviorPerPath.Builder> result = CacheBehaviorListCopier.copyToBuilder(this.cacheBehaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheBehaviors(Collection<CacheBehaviorPerPath.BuilderImpl> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copyFromBuilder(cacheBehaviors);
        }

        @Override
        public final Builder cacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
            this.cacheBehaviors = CacheBehaviorListCopier.copy(cacheBehaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
            this.cacheBehaviors(Arrays.asList(cacheBehaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... cacheBehaviors) {
            this.cacheBehaviors(Stream.of(cacheBehaviors).map(c -> (CacheBehaviorPerPath)((CacheBehaviorPerPath.Builder)CacheBehaviorPerPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final String getViewerMinimumTlsProtocolVersion() {
            return this.viewerMinimumTlsProtocolVersion;
        }

        public final void setViewerMinimumTlsProtocolVersion(String viewerMinimumTlsProtocolVersion) {
            this.viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion;
        }

        @Override
        public final Builder viewerMinimumTlsProtocolVersion(String viewerMinimumTlsProtocolVersion) {
            this.viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion;
            return this;
        }

        @Override
        public final Builder viewerMinimumTlsProtocolVersion(ViewerMinimumTlsProtocolVersionEnum viewerMinimumTlsProtocolVersion) {
            this.viewerMinimumTlsProtocolVersion(viewerMinimumTlsProtocolVersion == null ? null : viewerMinimumTlsProtocolVersion.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDistributionRequest build() {
            return new CreateDistributionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDistributionRequest> {
        public Builder distributionName(String var1);

        public Builder origin(InputOrigin var1);

        default public Builder origin(Consumer<InputOrigin.Builder> origin) {
            return this.origin((InputOrigin)((InputOrigin.Builder)InputOrigin.builder().applyMutation(origin)).build());
        }

        public Builder defaultCacheBehavior(CacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<CacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((CacheBehavior)((CacheBehavior.Builder)CacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviorSettings(CacheSettings var1);

        default public Builder cacheBehaviorSettings(Consumer<CacheSettings.Builder> cacheBehaviorSettings) {
            return this.cacheBehaviorSettings((CacheSettings)((CacheSettings.Builder)CacheSettings.builder().applyMutation(cacheBehaviorSettings)).build());
        }

        public Builder cacheBehaviors(Collection<CacheBehaviorPerPath> var1);

        public Builder cacheBehaviors(CacheBehaviorPerPath ... var1);

        public Builder cacheBehaviors(Consumer<CacheBehaviorPerPath.Builder> ... var1);

        public Builder bundleId(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder certificateName(String var1);

        public Builder viewerMinimumTlsProtocolVersion(String var1);

        public Builder viewerMinimumTlsProtocolVersion(ViewerMinimumTlsProtocolVersionEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

