/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMapSpritesResponse extends LocationResponse implements
        ToCopyableBuilder<GetMapSpritesResponse.Builder, GetMapSpritesResponse> {
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Blob")
            .getter(getter(GetMapSpritesResponse::blob))
            .setter(setter(Builder::blob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blob").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(GetMapSpritesResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BLOB_FIELD, CONTENT_TYPE_FIELD));

    private final SdkBytes blob;

    private final String contentType;

    private GetMapSpritesResponse(BuilderImpl builder) {
        super(builder);
        this.blob = builder.blob;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * Contains the body of the sprite sheet or JSON offset ﬁle.
     * </p>
     * 
     * @return Contains the body of the sprite sheet or JSON offset ﬁle.
     */
    public final SdkBytes blob() {
        return blob;
    }

    /**
     * <p>
     * The content type of the sprite sheet and offsets. For example, the sprite sheet content type is
     * <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>.
     * </p>
     * 
     * @return The content type of the sprite sheet and offsets. For example, the sprite sheet content type is
     *         <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blob());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapSpritesResponse)) {
            return false;
        }
        GetMapSpritesResponse other = (GetMapSpritesResponse) obj;
        return Objects.equals(blob(), other.blob()) && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMapSpritesResponse").add("Blob", blob()).add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blob":
            return Optional.ofNullable(clazz.cast(blob()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMapSpritesResponse, T> g) {
        return obj -> g.apply((GetMapSpritesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMapSpritesResponse> {
        /**
         * <p>
         * Contains the body of the sprite sheet or JSON offset ﬁle.
         * </p>
         * 
         * @param blob
         *        Contains the body of the sprite sheet or JSON offset ﬁle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blob(SdkBytes blob);

        /**
         * <p>
         * The content type of the sprite sheet and offsets. For example, the sprite sheet content type is
         * <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>.
         * </p>
         * 
         * @param contentType
         *        The content type of the sprite sheet and offsets. For example, the sprite sheet content type is
         *        <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private SdkBytes blob;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapSpritesResponse model) {
            super(model);
            blob(model.blob);
            contentType(model.contentType);
        }

        public final ByteBuffer getBlob() {
            return blob == null ? null : blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            blob(blob == null ? null : SdkBytes.fromByteBuffer(blob));
        }

        @Override
        @Transient
        public final Builder blob(SdkBytes blob) {
            this.blob = blob;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public GetMapSpritesResponse build() {
            return new GetMapSpritesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
