/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRouteCalculatorResponse extends LocationResponse implements
        ToCopyableBuilder<UpdateRouteCalculatorResponse.Builder, UpdateRouteCalculatorResponse> {
    private static final SdkField<String> CALCULATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatorArn").getter(getter(UpdateRouteCalculatorResponse::calculatorArn))
            .setter(setter(Builder::calculatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorArn").build()).build();

    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatorName").getter(getter(UpdateRouteCalculatorResponse::calculatorName))
            .setter(setter(Builder::calculatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(UpdateRouteCalculatorResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_ARN_FIELD,
            CALCULATOR_NAME_FIELD, UPDATE_TIME_FIELD));

    private final String calculatorArn;

    private final String calculatorName;

    private final Instant updateTime;

    private UpdateRouteCalculatorResponse(BuilderImpl builder) {
        super(builder);
        this.calculatorArn = builder.calculatorArn;
        this.calculatorName = builder.calculatorName;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource
     *         across AWS.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code>
     *         </p>
     *         </li>
     */
    public final String calculatorArn() {
        return calculatorArn;
    }

    /**
     * <p>
     * The name of the updated route calculator resource.
     * </p>
     * 
     * @return The name of the updated route calculator resource.
     */
    public final String calculatorName() {
        return calculatorName;
    }

    /**
     * <p>
     * The timestamp for when the route calculator was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the route calculator was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calculatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRouteCalculatorResponse)) {
            return false;
        }
        UpdateRouteCalculatorResponse other = (UpdateRouteCalculatorResponse) obj;
        return Objects.equals(calculatorArn(), other.calculatorArn()) && Objects.equals(calculatorName(), other.calculatorName())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRouteCalculatorResponse").add("CalculatorArn", calculatorArn())
                .add("CalculatorName", calculatorName()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculatorArn":
            return Optional.ofNullable(clazz.cast(calculatorArn()));
        case "CalculatorName":
            return Optional.ofNullable(clazz.cast(calculatorName()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRouteCalculatorResponse, T> g) {
        return obj -> g.apply((UpdateRouteCalculatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRouteCalculatorResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across
         * AWS.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param calculatorArn
         *        The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource
         *        across AWS.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatorArn(String calculatorArn);

        /**
         * <p>
         * The name of the updated route calculator resource.
         * </p>
         * 
         * @param calculatorName
         *        The name of the updated route calculator resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatorName(String calculatorName);

        /**
         * <p>
         * The timestamp for when the route calculator was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the route calculator was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String calculatorArn;

        private String calculatorName;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRouteCalculatorResponse model) {
            super(model);
            calculatorArn(model.calculatorArn);
            calculatorName(model.calculatorName);
            updateTime(model.updateTime);
        }

        public final String getCalculatorArn() {
            return calculatorArn;
        }

        public final void setCalculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
        }

        @Override
        @Transient
        public final Builder calculatorArn(String calculatorArn) {
            this.calculatorArn = calculatorArn;
            return this;
        }

        public final String getCalculatorName() {
            return calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        @Transient
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        @Transient
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateRouteCalculatorResponse build() {
            return new UpdateRouteCalculatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
