/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.PositionalAccuracy;
import software.amazon.awssdk.services.location.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DevicePositionUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DevicePositionUpdate> {
    private static final SdkField<PositionalAccuracy> ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Accuracy").getter(DevicePositionUpdate.getter(DevicePositionUpdate::accuracy)).setter(DevicePositionUpdate.setter(Builder::accuracy)).constructor(PositionalAccuracy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(DevicePositionUpdate.getter(DevicePositionUpdate::deviceId)).setter(DevicePositionUpdate.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(DevicePositionUpdate.getter(DevicePositionUpdate::position)).setter(DevicePositionUpdate.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> POSITION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PositionProperties").getter(DevicePositionUpdate.getter(DevicePositionUpdate::positionProperties)).setter(DevicePositionUpdate.setter(Builder::positionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(DevicePositionUpdate.getter(DevicePositionUpdate::sampleTime)).setter(DevicePositionUpdate.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCURACY_FIELD, DEVICE_ID_FIELD, POSITION_FIELD, POSITION_PROPERTIES_FIELD, SAMPLE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final PositionalAccuracy accuracy;
    private final String deviceId;
    private final List<Double> position;
    private final Map<String, String> positionProperties;
    private final Instant sampleTime;

    private DevicePositionUpdate(BuilderImpl builder) {
        this.accuracy = builder.accuracy;
        this.deviceId = builder.deviceId;
        this.position = builder.position;
        this.positionProperties = builder.positionProperties;
        this.sampleTime = builder.sampleTime;
    }

    public final PositionalAccuracy accuracy() {
        return this.accuracy;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final boolean hasPositionProperties() {
        return this.positionProperties != null && !(this.positionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> positionProperties() {
        return this.positionProperties;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPositionProperties() ? this.positionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePositionUpdate)) {
            return false;
        }
        DevicePositionUpdate other = (DevicePositionUpdate)obj;
        return Objects.equals(this.accuracy(), other.accuracy()) && Objects.equals(this.deviceId(), other.deviceId()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && this.hasPositionProperties() == other.hasPositionProperties() && Objects.equals(this.positionProperties(), other.positionProperties()) && Objects.equals(this.sampleTime(), other.sampleTime());
    }

    public final String toString() {
        return ToString.builder((String)"DevicePositionUpdate").add("Accuracy", (Object)this.accuracy()).add("DeviceId", (Object)this.deviceId()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("PositionProperties", (Object)(this.positionProperties() == null ? null : "*** Sensitive Data Redacted ***")).add("SampleTime", (Object)this.sampleTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accuracy": {
                return Optional.ofNullable(clazz.cast(this.accuracy()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "PositionProperties": {
                return Optional.ofNullable(clazz.cast(this.positionProperties()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevicePositionUpdate, T> g) {
        return obj -> g.apply((DevicePositionUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PositionalAccuracy accuracy;
        private String deviceId;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> positionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Instant sampleTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePositionUpdate model) {
            this.accuracy(model.accuracy);
            this.deviceId(model.deviceId);
            this.position(model.position);
            this.positionProperties(model.positionProperties);
            this.sampleTime(model.sampleTime);
        }

        public final PositionalAccuracy.Builder getAccuracy() {
            return this.accuracy != null ? this.accuracy.toBuilder() : null;
        }

        public final void setAccuracy(PositionalAccuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        @Transient
        public final Builder accuracy(PositionalAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        @Transient
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Map<String, String> getPositionProperties() {
            if (this.positionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.positionProperties;
        }

        public final void setPositionProperties(Map<String, String> positionProperties) {
            this.positionProperties = PropertyMapCopier.copy(positionProperties);
        }

        @Override
        @Transient
        public final Builder positionProperties(Map<String, String> positionProperties) {
            this.positionProperties = PropertyMapCopier.copy(positionProperties);
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        @Transient
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public DevicePositionUpdate build() {
            return new DevicePositionUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DevicePositionUpdate> {
        public Builder accuracy(PositionalAccuracy var1);

        default public Builder accuracy(Consumer<PositionalAccuracy.Builder> accuracy) {
            return this.accuracy((PositionalAccuracy)((PositionalAccuracy.Builder)PositionalAccuracy.builder().applyMutation(accuracy)).build());
        }

        public Builder deviceId(String var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder positionProperties(Map<String, String> var1);

        public Builder sampleTime(Instant var1);
    }
}

