/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.AndroidApp;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowActionsListCopier;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowAndroidAppsListCopier;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowAppleAppsListCopier;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowReferersListCopier;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictionsAllowResourcesListCopier;
import software.amazon.awssdk.services.location.model.AppleApp;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiKeyRestrictions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiKeyRestrictions> {
    private static final SdkField<List<String>> ALLOW_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowActions").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowActions)).setter(ApiKeyRestrictions.setter(Builder::allowActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowResources").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowResources)).setter(ApiKeyRestrictions.setter(Builder::allowResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_REFERERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowReferers").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowReferers)).setter(ApiKeyRestrictions.setter(Builder::allowReferers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReferers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AndroidApp>> ALLOW_ANDROID_APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowAndroidApps").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowAndroidApps)).setter(ApiKeyRestrictions.setter(Builder::allowAndroidApps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowAndroidApps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AndroidApp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AppleApp>> ALLOW_APPLE_APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowAppleApps").getter(ApiKeyRestrictions.getter(ApiKeyRestrictions::allowAppleApps)).setter(ApiKeyRestrictions.setter(Builder::allowAppleApps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowAppleApps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppleApp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_ACTIONS_FIELD, ALLOW_RESOURCES_FIELD, ALLOW_REFERERS_FIELD, ALLOW_ANDROID_APPS_FIELD, ALLOW_APPLE_APPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiKeyRestrictions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allowActions;
    private final List<String> allowResources;
    private final List<String> allowReferers;
    private final List<AndroidApp> allowAndroidApps;
    private final List<AppleApp> allowAppleApps;

    private ApiKeyRestrictions(BuilderImpl builder) {
        this.allowActions = builder.allowActions;
        this.allowResources = builder.allowResources;
        this.allowReferers = builder.allowReferers;
        this.allowAndroidApps = builder.allowAndroidApps;
        this.allowAppleApps = builder.allowAppleApps;
    }

    public final boolean hasAllowActions() {
        return this.allowActions != null && !(this.allowActions instanceof SdkAutoConstructList);
    }

    public final List<String> allowActions() {
        return this.allowActions;
    }

    public final boolean hasAllowResources() {
        return this.allowResources != null && !(this.allowResources instanceof SdkAutoConstructList);
    }

    public final List<String> allowResources() {
        return this.allowResources;
    }

    public final boolean hasAllowReferers() {
        return this.allowReferers != null && !(this.allowReferers instanceof SdkAutoConstructList);
    }

    public final List<String> allowReferers() {
        return this.allowReferers;
    }

    public final boolean hasAllowAndroidApps() {
        return this.allowAndroidApps != null && !(this.allowAndroidApps instanceof SdkAutoConstructList);
    }

    public final List<AndroidApp> allowAndroidApps() {
        return this.allowAndroidApps;
    }

    public final boolean hasAllowAppleApps() {
        return this.allowAppleApps != null && !(this.allowAppleApps instanceof SdkAutoConstructList);
    }

    public final List<AppleApp> allowAppleApps() {
        return this.allowAppleApps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowActions() ? this.allowActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowResources() ? this.allowResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowReferers() ? this.allowReferers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowAndroidApps() ? this.allowAndroidApps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowAppleApps() ? this.allowAppleApps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKeyRestrictions)) {
            return false;
        }
        ApiKeyRestrictions other = (ApiKeyRestrictions)obj;
        return this.hasAllowActions() == other.hasAllowActions() && Objects.equals(this.allowActions(), other.allowActions()) && this.hasAllowResources() == other.hasAllowResources() && Objects.equals(this.allowResources(), other.allowResources()) && this.hasAllowReferers() == other.hasAllowReferers() && Objects.equals(this.allowReferers(), other.allowReferers()) && this.hasAllowAndroidApps() == other.hasAllowAndroidApps() && Objects.equals(this.allowAndroidApps(), other.allowAndroidApps()) && this.hasAllowAppleApps() == other.hasAllowAppleApps() && Objects.equals(this.allowAppleApps(), other.allowAppleApps());
    }

    public final String toString() {
        return ToString.builder((String)"ApiKeyRestrictions").add("AllowActions", this.hasAllowActions() ? this.allowActions() : null).add("AllowResources", this.hasAllowResources() ? this.allowResources() : null).add("AllowReferers", (Object)(this.allowReferers() == null ? null : "*** Sensitive Data Redacted ***")).add("AllowAndroidApps", this.hasAllowAndroidApps() ? this.allowAndroidApps() : null).add("AllowAppleApps", this.hasAllowAppleApps() ? this.allowAppleApps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowActions": {
                return Optional.ofNullable(clazz.cast(this.allowActions()));
            }
            case "AllowResources": {
                return Optional.ofNullable(clazz.cast(this.allowResources()));
            }
            case "AllowReferers": {
                return Optional.ofNullable(clazz.cast(this.allowReferers()));
            }
            case "AllowAndroidApps": {
                return Optional.ofNullable(clazz.cast(this.allowAndroidApps()));
            }
            case "AllowAppleApps": {
                return Optional.ofNullable(clazz.cast(this.allowAppleApps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllowActions", ALLOW_ACTIONS_FIELD);
        map.put("AllowResources", ALLOW_RESOURCES_FIELD);
        map.put("AllowReferers", ALLOW_REFERERS_FIELD);
        map.put("AllowAndroidApps", ALLOW_ANDROID_APPS_FIELD);
        map.put("AllowAppleApps", ALLOW_APPLE_APPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiKeyRestrictions, T> g) {
        return obj -> g.apply((ApiKeyRestrictions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowResources = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowReferers = DefaultSdkAutoConstructList.getInstance();
        private List<AndroidApp> allowAndroidApps = DefaultSdkAutoConstructList.getInstance();
        private List<AppleApp> allowAppleApps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKeyRestrictions model) {
            this.allowActions(model.allowActions);
            this.allowResources(model.allowResources);
            this.allowReferers(model.allowReferers);
            this.allowAndroidApps(model.allowAndroidApps);
            this.allowAppleApps(model.allowAppleApps);
        }

        public final Collection<String> getAllowActions() {
            if (this.allowActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowActions;
        }

        public final void setAllowActions(Collection<String> allowActions) {
            this.allowActions = ApiKeyRestrictionsAllowActionsListCopier.copy(allowActions);
        }

        @Override
        public final Builder allowActions(Collection<String> allowActions) {
            this.allowActions = ApiKeyRestrictionsAllowActionsListCopier.copy(allowActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowActions(String ... allowActions) {
            this.allowActions(Arrays.asList(allowActions));
            return this;
        }

        public final Collection<String> getAllowResources() {
            if (this.allowResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowResources;
        }

        public final void setAllowResources(Collection<String> allowResources) {
            this.allowResources = ApiKeyRestrictionsAllowResourcesListCopier.copy(allowResources);
        }

        @Override
        public final Builder allowResources(Collection<String> allowResources) {
            this.allowResources = ApiKeyRestrictionsAllowResourcesListCopier.copy(allowResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowResources(String ... allowResources) {
            this.allowResources(Arrays.asList(allowResources));
            return this;
        }

        public final Collection<String> getAllowReferers() {
            if (this.allowReferers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowReferers;
        }

        public final void setAllowReferers(Collection<String> allowReferers) {
            this.allowReferers = ApiKeyRestrictionsAllowReferersListCopier.copy(allowReferers);
        }

        @Override
        public final Builder allowReferers(Collection<String> allowReferers) {
            this.allowReferers = ApiKeyRestrictionsAllowReferersListCopier.copy(allowReferers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowReferers(String ... allowReferers) {
            this.allowReferers(Arrays.asList(allowReferers));
            return this;
        }

        public final List<AndroidApp.Builder> getAllowAndroidApps() {
            List<AndroidApp.Builder> result = ApiKeyRestrictionsAllowAndroidAppsListCopier.copyToBuilder(this.allowAndroidApps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowAndroidApps(Collection<AndroidApp.BuilderImpl> allowAndroidApps) {
            this.allowAndroidApps = ApiKeyRestrictionsAllowAndroidAppsListCopier.copyFromBuilder(allowAndroidApps);
        }

        @Override
        public final Builder allowAndroidApps(Collection<AndroidApp> allowAndroidApps) {
            this.allowAndroidApps = ApiKeyRestrictionsAllowAndroidAppsListCopier.copy(allowAndroidApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowAndroidApps(AndroidApp ... allowAndroidApps) {
            this.allowAndroidApps(Arrays.asList(allowAndroidApps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowAndroidApps(Consumer<AndroidApp.Builder> ... allowAndroidApps) {
            this.allowAndroidApps(Stream.of(allowAndroidApps).map(c -> (AndroidApp)((AndroidApp.Builder)AndroidApp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AppleApp.Builder> getAllowAppleApps() {
            List<AppleApp.Builder> result = ApiKeyRestrictionsAllowAppleAppsListCopier.copyToBuilder(this.allowAppleApps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowAppleApps(Collection<AppleApp.BuilderImpl> allowAppleApps) {
            this.allowAppleApps = ApiKeyRestrictionsAllowAppleAppsListCopier.copyFromBuilder(allowAppleApps);
        }

        @Override
        public final Builder allowAppleApps(Collection<AppleApp> allowAppleApps) {
            this.allowAppleApps = ApiKeyRestrictionsAllowAppleAppsListCopier.copy(allowAppleApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowAppleApps(AppleApp ... allowAppleApps) {
            this.allowAppleApps(Arrays.asList(allowAppleApps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowAppleApps(Consumer<AppleApp.Builder> ... allowAppleApps) {
            this.allowAppleApps(Stream.of(allowAppleApps).map(c -> (AppleApp)((AppleApp.Builder)AppleApp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ApiKeyRestrictions build() {
            return new ApiKeyRestrictions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiKeyRestrictions> {
        public Builder allowActions(Collection<String> var1);

        public Builder allowActions(String ... var1);

        public Builder allowResources(Collection<String> var1);

        public Builder allowResources(String ... var1);

        public Builder allowReferers(Collection<String> var1);

        public Builder allowReferers(String ... var1);

        public Builder allowAndroidApps(Collection<AndroidApp> var1);

        public Builder allowAndroidApps(AndroidApp ... var1);

        public Builder allowAndroidApps(Consumer<AndroidApp.Builder> ... var1);

        public Builder allowAppleApps(Collection<AppleApp> var1);

        public Builder allowAppleApps(AppleApp ... var1);

        public Builder allowAppleApps(Consumer<AppleApp.Builder> ... var1);
    }
}

