/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions;
import software.amazon.awssdk.services.location.model.CalculateRouteRequestWaypointPositionsListCopier;
import software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.OptimizationMode;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.services.location.model.TravelMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, CalculateRouteRequest> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(CalculateRouteRequest.getter(CalculateRouteRequest::calculatorName)).setter(CalculateRouteRequest.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatorName").build()}).build();
    private static final SdkField<List<Double>> DEPARTURE_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeparturePosition").getter(CalculateRouteRequest.getter(CalculateRouteRequest::departurePosition)).setter(CalculateRouteRequest.setter(Builder::departurePosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeparturePosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> DESTINATION_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPosition").getter(CalculateRouteRequest.getter(CalculateRouteRequest::destinationPosition)).setter(CalculateRouteRequest.setter(Builder::destinationPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<Double>>> WAYPOINT_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WaypointPositions").getter(CalculateRouteRequest.getter(CalculateRouteRequest::waypointPositions)).setter(CalculateRouteRequest.setter(Builder::waypointPositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaypointPositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(CalculateRouteRequest.getter(CalculateRouteRequest::travelModeAsString)).setter(CalculateRouteRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<Instant> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DepartureTime").getter(CalculateRouteRequest.getter(CalculateRouteRequest::departureTime)).setter(CalculateRouteRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DepartNow").getter(CalculateRouteRequest.getter(CalculateRouteRequest::departNow)).setter(CalculateRouteRequest.setter(Builder::departNow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(CalculateRouteRequest.getter(CalculateRouteRequest::distanceUnitAsString)).setter(CalculateRouteRequest.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<Boolean> INCLUDE_LEG_GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeLegGeometry").getter(CalculateRouteRequest.getter(CalculateRouteRequest::includeLegGeometry)).setter(CalculateRouteRequest.setter(Builder::includeLegGeometry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeLegGeometry").build()}).build();
    private static final SdkField<CalculateRouteCarModeOptions> CAR_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CarModeOptions").getter(CalculateRouteRequest.getter(CalculateRouteRequest::carModeOptions)).setter(CalculateRouteRequest.setter(Builder::carModeOptions)).constructor(CalculateRouteCarModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarModeOptions").build()}).build();
    private static final SdkField<CalculateRouteTruckModeOptions> TRUCK_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TruckModeOptions").getter(CalculateRouteRequest.getter(CalculateRouteRequest::truckModeOptions)).setter(CalculateRouteRequest.setter(Builder::truckModeOptions)).constructor(CalculateRouteTruckModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckModeOptions").build()}).build();
    private static final SdkField<Instant> ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ArrivalTime").getter(CalculateRouteRequest.getter(CalculateRouteRequest::arrivalTime)).setter(CalculateRouteRequest.setter(Builder::arrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OPTIMIZE_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizeFor").getter(CalculateRouteRequest.getter(CalculateRouteRequest::optimizeForAsString)).setter(CalculateRouteRequest.setter(Builder::optimizeFor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeFor").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(CalculateRouteRequest.getter(CalculateRouteRequest::key)).setter(CalculateRouteRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD, DEPARTURE_POSITION_FIELD, DESTINATION_POSITION_FIELD, WAYPOINT_POSITIONS_FIELD, TRAVEL_MODE_FIELD, DEPARTURE_TIME_FIELD, DEPART_NOW_FIELD, DISTANCE_UNIT_FIELD, INCLUDE_LEG_GEOMETRY_FIELD, CAR_MODE_OPTIONS_FIELD, TRUCK_MODE_OPTIONS_FIELD, ARRIVAL_TIME_FIELD, OPTIMIZE_FOR_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateRouteRequest.memberNameToFieldInitializer();
    private final String calculatorName;
    private final List<Double> departurePosition;
    private final List<Double> destinationPosition;
    private final List<List<Double>> waypointPositions;
    private final String travelMode;
    private final Instant departureTime;
    private final Boolean departNow;
    private final String distanceUnit;
    private final Boolean includeLegGeometry;
    private final CalculateRouteCarModeOptions carModeOptions;
    private final CalculateRouteTruckModeOptions truckModeOptions;
    private final Instant arrivalTime;
    private final String optimizeFor;
    private final String key;

    private CalculateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.calculatorName = builder.calculatorName;
        this.departurePosition = builder.departurePosition;
        this.destinationPosition = builder.destinationPosition;
        this.waypointPositions = builder.waypointPositions;
        this.travelMode = builder.travelMode;
        this.departureTime = builder.departureTime;
        this.departNow = builder.departNow;
        this.distanceUnit = builder.distanceUnit;
        this.includeLegGeometry = builder.includeLegGeometry;
        this.carModeOptions = builder.carModeOptions;
        this.truckModeOptions = builder.truckModeOptions;
        this.arrivalTime = builder.arrivalTime;
        this.optimizeFor = builder.optimizeFor;
        this.key = builder.key;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final boolean hasDeparturePosition() {
        return this.departurePosition != null && !(this.departurePosition instanceof SdkAutoConstructList);
    }

    public final List<Double> departurePosition() {
        return this.departurePosition;
    }

    public final boolean hasDestinationPosition() {
        return this.destinationPosition != null && !(this.destinationPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> destinationPosition() {
        return this.destinationPosition;
    }

    public final boolean hasWaypointPositions() {
        return this.waypointPositions != null && !(this.waypointPositions instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> waypointPositions() {
        return this.waypointPositions;
    }

    public final TravelMode travelMode() {
        return TravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final Instant departureTime() {
        return this.departureTime;
    }

    public final Boolean departNow() {
        return this.departNow;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final Boolean includeLegGeometry() {
        return this.includeLegGeometry;
    }

    public final CalculateRouteCarModeOptions carModeOptions() {
        return this.carModeOptions;
    }

    public final CalculateRouteTruckModeOptions truckModeOptions() {
        return this.truckModeOptions;
    }

    public final Instant arrivalTime() {
        return this.arrivalTime;
    }

    public final OptimizationMode optimizeFor() {
        return OptimizationMode.fromValue(this.optimizeFor);
    }

    public final String optimizeForAsString() {
        return this.optimizeFor;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeparturePosition() ? this.departurePosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPosition() ? this.destinationPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWaypointPositions() ? this.waypointPositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.departNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeLegGeometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.carModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.truckModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteRequest)) {
            return false;
        }
        CalculateRouteRequest other = (CalculateRouteRequest)((Object)obj);
        return Objects.equals(this.calculatorName(), other.calculatorName()) && this.hasDeparturePosition() == other.hasDeparturePosition() && Objects.equals(this.departurePosition(), other.departurePosition()) && this.hasDestinationPosition() == other.hasDestinationPosition() && Objects.equals(this.destinationPosition(), other.destinationPosition()) && this.hasWaypointPositions() == other.hasWaypointPositions() && Objects.equals(this.waypointPositions(), other.waypointPositions()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.departureTime(), other.departureTime()) && Objects.equals(this.departNow(), other.departNow()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.includeLegGeometry(), other.includeLegGeometry()) && Objects.equals(this.carModeOptions(), other.carModeOptions()) && Objects.equals(this.truckModeOptions(), other.truckModeOptions()) && Objects.equals(this.arrivalTime(), other.arrivalTime()) && Objects.equals(this.optimizeForAsString(), other.optimizeForAsString()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteRequest").add("CalculatorName", (Object)this.calculatorName()).add("DeparturePosition", (Object)(this.departurePosition() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationPosition", (Object)(this.destinationPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("WaypointPositions", (Object)(this.waypointPositions() == null ? null : "*** Sensitive Data Redacted ***")).add("TravelMode", (Object)this.travelModeAsString()).add("DepartureTime", (Object)(this.departureTime() == null ? null : "*** Sensitive Data Redacted ***")).add("DepartNow", (Object)(this.departNow() == null ? null : "*** Sensitive Data Redacted ***")).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("IncludeLegGeometry", (Object)(this.includeLegGeometry() == null ? null : "*** Sensitive Data Redacted ***")).add("CarModeOptions", (Object)this.carModeOptions()).add("TruckModeOptions", (Object)this.truckModeOptions()).add("ArrivalTime", (Object)(this.arrivalTime() == null ? null : "*** Sensitive Data Redacted ***")).add("OptimizeFor", (Object)this.optimizeForAsString()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "DeparturePosition": {
                return Optional.ofNullable(clazz.cast(this.departurePosition()));
            }
            case "DestinationPosition": {
                return Optional.ofNullable(clazz.cast(this.destinationPosition()));
            }
            case "WaypointPositions": {
                return Optional.ofNullable(clazz.cast(this.waypointPositions()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "DepartNow": {
                return Optional.ofNullable(clazz.cast(this.departNow()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "IncludeLegGeometry": {
                return Optional.ofNullable(clazz.cast(this.includeLegGeometry()));
            }
            case "CarModeOptions": {
                return Optional.ofNullable(clazz.cast(this.carModeOptions()));
            }
            case "TruckModeOptions": {
                return Optional.ofNullable(clazz.cast(this.truckModeOptions()));
            }
            case "ArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.arrivalTime()));
            }
            case "OptimizeFor": {
                return Optional.ofNullable(clazz.cast(this.optimizeForAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CalculatorName", CALCULATOR_NAME_FIELD);
        map.put("DeparturePosition", DEPARTURE_POSITION_FIELD);
        map.put("DestinationPosition", DESTINATION_POSITION_FIELD);
        map.put("WaypointPositions", WAYPOINT_POSITIONS_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("DepartNow", DEPART_NOW_FIELD);
        map.put("DistanceUnit", DISTANCE_UNIT_FIELD);
        map.put("IncludeLegGeometry", INCLUDE_LEG_GEOMETRY_FIELD);
        map.put("CarModeOptions", CAR_MODE_OPTIONS_FIELD);
        map.put("TruckModeOptions", TRUCK_MODE_OPTIONS_FIELD);
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("OptimizeFor", OPTIMIZE_FOR_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteRequest, T> g) {
        return obj -> g.apply((CalculateRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String calculatorName;
        private List<Double> departurePosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> destinationPosition = DefaultSdkAutoConstructList.getInstance();
        private List<List<Double>> waypointPositions = DefaultSdkAutoConstructList.getInstance();
        private String travelMode;
        private Instant departureTime;
        private Boolean departNow;
        private String distanceUnit;
        private Boolean includeLegGeometry;
        private CalculateRouteCarModeOptions carModeOptions;
        private CalculateRouteTruckModeOptions truckModeOptions;
        private Instant arrivalTime;
        private String optimizeFor;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteRequest model) {
            super(model);
            this.calculatorName(model.calculatorName);
            this.departurePosition(model.departurePosition);
            this.destinationPosition(model.destinationPosition);
            this.waypointPositions(model.waypointPositions);
            this.travelMode(model.travelMode);
            this.departureTime(model.departureTime);
            this.departNow(model.departNow);
            this.distanceUnit(model.distanceUnit);
            this.includeLegGeometry(model.includeLegGeometry);
            this.carModeOptions(model.carModeOptions);
            this.truckModeOptions(model.truckModeOptions);
            this.arrivalTime(model.arrivalTime);
            this.optimizeFor(model.optimizeFor);
            this.key(model.key);
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final Collection<Double> getDeparturePosition() {
            if (this.departurePosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.departurePosition;
        }

        public final void setDeparturePosition(Collection<Double> departurePosition) {
            this.departurePosition = PositionCopier.copy(departurePosition);
        }

        @Override
        public final Builder departurePosition(Collection<Double> departurePosition) {
            this.departurePosition = PositionCopier.copy(departurePosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder departurePosition(Double ... departurePosition) {
            this.departurePosition(Arrays.asList(departurePosition));
            return this;
        }

        public final Collection<Double> getDestinationPosition() {
            if (this.destinationPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPosition;
        }

        public final void setDestinationPosition(Collection<Double> destinationPosition) {
            this.destinationPosition = PositionCopier.copy(destinationPosition);
        }

        @Override
        public final Builder destinationPosition(Collection<Double> destinationPosition) {
            this.destinationPosition = PositionCopier.copy(destinationPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPosition(Double ... destinationPosition) {
            this.destinationPosition(Arrays.asList(destinationPosition));
            return this;
        }

        public final Collection<? extends Collection<Double>> getWaypointPositions() {
            if (this.waypointPositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.waypointPositions;
        }

        public final void setWaypointPositions(Collection<? extends Collection<Double>> waypointPositions) {
            this.waypointPositions = CalculateRouteRequestWaypointPositionsListCopier.copy(waypointPositions);
        }

        @Override
        public final Builder waypointPositions(Collection<? extends Collection<Double>> waypointPositions) {
            this.waypointPositions = CalculateRouteRequestWaypointPositionsListCopier.copy(waypointPositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypointPositions(Collection<Double> ... waypointPositions) {
            this.waypointPositions((Collection<? extends Collection<Double>>)Arrays.asList(waypointPositions));
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(TravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final Instant getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(Instant departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(Instant departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Boolean getDepartNow() {
            return this.departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final Boolean getIncludeLegGeometry() {
            return this.includeLegGeometry;
        }

        public final void setIncludeLegGeometry(Boolean includeLegGeometry) {
            this.includeLegGeometry = includeLegGeometry;
        }

        @Override
        public final Builder includeLegGeometry(Boolean includeLegGeometry) {
            this.includeLegGeometry = includeLegGeometry;
            return this;
        }

        public final CalculateRouteCarModeOptions.Builder getCarModeOptions() {
            return this.carModeOptions != null ? this.carModeOptions.toBuilder() : null;
        }

        public final void setCarModeOptions(CalculateRouteCarModeOptions.BuilderImpl carModeOptions) {
            this.carModeOptions = carModeOptions != null ? carModeOptions.build() : null;
        }

        @Override
        public final Builder carModeOptions(CalculateRouteCarModeOptions carModeOptions) {
            this.carModeOptions = carModeOptions;
            return this;
        }

        public final CalculateRouteTruckModeOptions.Builder getTruckModeOptions() {
            return this.truckModeOptions != null ? this.truckModeOptions.toBuilder() : null;
        }

        public final void setTruckModeOptions(CalculateRouteTruckModeOptions.BuilderImpl truckModeOptions) {
            this.truckModeOptions = truckModeOptions != null ? truckModeOptions.build() : null;
        }

        @Override
        public final Builder truckModeOptions(CalculateRouteTruckModeOptions truckModeOptions) {
            this.truckModeOptions = truckModeOptions;
            return this;
        }

        public final Instant getArrivalTime() {
            return this.arrivalTime;
        }

        public final void setArrivalTime(Instant arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(Instant arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final String getOptimizeFor() {
            return this.optimizeFor;
        }

        public final void setOptimizeFor(String optimizeFor) {
            this.optimizeFor = optimizeFor;
        }

        @Override
        public final Builder optimizeFor(String optimizeFor) {
            this.optimizeFor = optimizeFor;
            return this;
        }

        @Override
        public final Builder optimizeFor(OptimizationMode optimizeFor) {
            this.optimizeFor(optimizeFor == null ? null : optimizeFor.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateRouteRequest build() {
            return new CalculateRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteRequest> {
        public Builder calculatorName(String var1);

        public Builder departurePosition(Collection<Double> var1);

        public Builder departurePosition(Double ... var1);

        public Builder destinationPosition(Collection<Double> var1);

        public Builder destinationPosition(Double ... var1);

        public Builder waypointPositions(Collection<? extends Collection<Double>> var1);

        public Builder waypointPositions(Collection<Double> ... var1);

        public Builder travelMode(String var1);

        public Builder travelMode(TravelMode var1);

        public Builder departureTime(Instant var1);

        public Builder departNow(Boolean var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder includeLegGeometry(Boolean var1);

        public Builder carModeOptions(CalculateRouteCarModeOptions var1);

        default public Builder carModeOptions(Consumer<CalculateRouteCarModeOptions.Builder> carModeOptions) {
            return this.carModeOptions((CalculateRouteCarModeOptions)((CalculateRouteCarModeOptions.Builder)CalculateRouteCarModeOptions.builder().applyMutation(carModeOptions)).build());
        }

        public Builder truckModeOptions(CalculateRouteTruckModeOptions var1);

        default public Builder truckModeOptions(Consumer<CalculateRouteTruckModeOptions.Builder> truckModeOptions) {
            return this.truckModeOptions((CalculateRouteTruckModeOptions)((CalculateRouteTruckModeOptions.Builder)CalculateRouteTruckModeOptions.builder().applyMutation(truckModeOptions)).build());
        }

        public Builder arrivalTime(Instant var1);

        public Builder optimizeFor(String var1);

        public Builder optimizeFor(OptimizationMode var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

