/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.ModelQuality;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelVersionSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ModelVersionSummary.getter(ModelVersionSummary::modelName)).setter(ModelVersionSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(ModelVersionSummary.getter(ModelVersionSummary::modelArn)).setter(ModelVersionSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ModelVersion").getter(ModelVersionSummary.getter(ModelVersionSummary::modelVersion)).setter(ModelVersionSummary.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersionArn").getter(ModelVersionSummary.getter(ModelVersionSummary::modelVersionArn)).setter(ModelVersionSummary.setter(Builder::modelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ModelVersionSummary.getter(ModelVersionSummary::createdAt)).setter(ModelVersionSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelVersionSummary.getter(ModelVersionSummary::statusAsString)).setter(ModelVersionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(ModelVersionSummary.getter(ModelVersionSummary::sourceTypeAsString)).setter(ModelVersionSummary.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelQuality").getter(ModelVersionSummary.getter(ModelVersionSummary::modelQualityAsString)).setter(ModelVersionSummary.setter(Builder::modelQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, MODEL_VERSION_FIELD, MODEL_VERSION_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD, SOURCE_TYPE_FIELD, MODEL_QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelArn;
    private final Long modelVersion;
    private final String modelVersionArn;
    private final Instant createdAt;
    private final String status;
    private final String sourceType;
    private final String modelQuality;

    private ModelVersionSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.modelVersion = builder.modelVersion;
        this.modelVersionArn = builder.modelVersionArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.sourceType = builder.sourceType;
        this.modelQuality = builder.modelQuality;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Long modelVersion() {
        return this.modelVersion;
    }

    public final String modelVersionArn() {
        return this.modelVersionArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelVersionSourceType sourceType() {
        return ModelVersionSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(this.modelQuality);
    }

    public final String modelQualityAsString() {
        return this.modelQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionSummary)) {
            return false;
        }
        ModelVersionSummary other = (ModelVersionSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelVersionArn(), other.modelVersionArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.modelQualityAsString(), other.modelQualityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelVersionSummary").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("ModelVersion", (Object)this.modelVersion()).add("ModelVersionArn", (Object)this.modelVersionArn()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("ModelQuality", (Object)this.modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelVersionArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "ModelQuality": {
                return Optional.ofNullable(clazz.cast(this.modelQualityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionSummary, T> g) {
        return obj -> g.apply((ModelVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private Long modelVersion;
        private String modelVersionArn;
        private Instant createdAt;
        private String status;
        private String sourceType;
        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionSummary model) {
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.modelVersion(model.modelVersion);
            this.modelVersionArn(model.modelVersionArn);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.sourceType(model.sourceType);
            this.modelQuality(model.modelQuality);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Long getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelVersionArn() {
            return this.modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ModelVersionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getModelQuality() {
            return this.modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        public ModelVersionSummary build() {
            return new ModelVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelVersionSummary> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder modelVersion(Long var1);

        public Builder modelVersionArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ModelVersionStatus var1);

        public Builder sourceType(String var1);

        public Builder sourceType(ModelVersionSourceType var1);

        public Builder modelQuality(String var1);

        public Builder modelQuality(ModelQuality var1);
    }
}

