/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.JsonFileCompression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JsonFormatDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JsonFormatDescriptor> {
    private static final SdkField<String> FILE_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCompression").getter(JsonFormatDescriptor.getter(JsonFormatDescriptor::fileCompressionAsString)).setter(JsonFormatDescriptor.setter(Builder::fileCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()}).build();
    private static final SdkField<String> CHARSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Charset").getter(JsonFormatDescriptor.getter(JsonFormatDescriptor::charset)).setter(JsonFormatDescriptor.setter(Builder::charset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD, CHARSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileCompression;
    private final String charset;

    private JsonFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
    }

    public final JsonFileCompression fileCompression() {
        return JsonFileCompression.fromValue(this.fileCompression);
    }

    public final String fileCompressionAsString() {
        return this.fileCompression;
    }

    public final String charset() {
        return this.charset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.charset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonFormatDescriptor)) {
            return false;
        }
        JsonFormatDescriptor other = (JsonFormatDescriptor)obj;
        return Objects.equals(this.fileCompressionAsString(), other.fileCompressionAsString()) && Objects.equals(this.charset(), other.charset());
    }

    public final String toString() {
        return ToString.builder((String)"JsonFormatDescriptor").add("FileCompression", (Object)this.fileCompressionAsString()).add("Charset", (Object)this.charset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileCompression": {
                return Optional.ofNullable(clazz.cast(this.fileCompressionAsString()));
            }
            case "Charset": {
                return Optional.ofNullable(clazz.cast(this.charset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JsonFormatDescriptor, T> g) {
        return obj -> g.apply((JsonFormatDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileCompression;
        private String charset;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonFormatDescriptor model) {
            this.fileCompression(model.fileCompression);
            this.charset(model.charset);
        }

        public final String getFileCompression() {
            return this.fileCompression;
        }

        public final void setFileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
        }

        @Override
        public final Builder fileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        @Override
        public final Builder fileCompression(JsonFileCompression fileCompression) {
            this.fileCompression(fileCompression == null ? null : fileCompression.toString());
            return this;
        }

        public final String getCharset() {
            return this.charset;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public JsonFormatDescriptor build() {
            return new JsonFormatDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JsonFormatDescriptor> {
        public Builder fileCompression(String var1);

        public Builder fileCompression(JsonFileCompression var1);

        public Builder charset(String var1);
    }
}

