/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnomalyDetectionExecutionsRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, DescribeAnomalyDetectionExecutionsRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(DescribeAnomalyDetectionExecutionsRequest.getter(DescribeAnomalyDetectionExecutionsRequest::anomalyDetectorArn)).setter(DescribeAnomalyDetectionExecutionsRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timestamp").getter(DescribeAnomalyDetectionExecutionsRequest.getter(DescribeAnomalyDetectionExecutionsRequest::timestamp)).setter(DescribeAnomalyDetectionExecutionsRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeAnomalyDetectionExecutionsRequest.getter(DescribeAnomalyDetectionExecutionsRequest::maxResults)).setter(DescribeAnomalyDetectionExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAnomalyDetectionExecutionsRequest.getter(DescribeAnomalyDetectionExecutionsRequest::nextToken)).setter(DescribeAnomalyDetectionExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, TIMESTAMP_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAnomalyDetectionExecutionsRequest.memberNameToFieldInitializer();
    private final String anomalyDetectorArn;
    private final String timestamp;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeAnomalyDetectionExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.timestamp = builder.timestamp;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectionExecutionsRequest)) {
            return false;
        }
        DescribeAnomalyDetectionExecutionsRequest other = (DescribeAnomalyDetectionExecutionsRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnomalyDetectionExecutionsRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("Timestamp", (Object)this.timestamp()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectionExecutionsRequest, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectionExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String timestamp;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectionExecutionsRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.timestamp(model.timestamp);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAnomalyDetectionExecutionsRequest build() {
            return new DescribeAnomalyDetectionExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnomalyDetectionExecutionsRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder timestamp(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

