/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetric;
import software.amazon.awssdk.services.lookoutmetrics.model.DataQualityMetricListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricSetDataQualityMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricSetDataQualityMetric> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetArn").getter(MetricSetDataQualityMetric.getter(MetricSetDataQualityMetric::metricSetArn)).setter(MetricSetDataQualityMetric.setter(Builder::metricSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()}).build();
    private static final SdkField<List<DataQualityMetric>> DATA_QUALITY_METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataQualityMetricList").getter(MetricSetDataQualityMetric.getter(MetricSetDataQualityMetric::dataQualityMetricList)).setter(MetricSetDataQualityMetric.setter(Builder::dataQualityMetricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityMetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD, DATA_QUALITY_METRIC_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricSetDataQualityMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricSetArn;
    private final List<DataQualityMetric> dataQualityMetricList;

    private MetricSetDataQualityMetric(BuilderImpl builder) {
        this.metricSetArn = builder.metricSetArn;
        this.dataQualityMetricList = builder.dataQualityMetricList;
    }

    public final String metricSetArn() {
        return this.metricSetArn;
    }

    public final boolean hasDataQualityMetricList() {
        return this.dataQualityMetricList != null && !(this.dataQualityMetricList instanceof SdkAutoConstructList);
    }

    public final List<DataQualityMetric> dataQualityMetricList() {
        return this.dataQualityMetricList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataQualityMetricList() ? this.dataQualityMetricList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSetDataQualityMetric)) {
            return false;
        }
        MetricSetDataQualityMetric other = (MetricSetDataQualityMetric)obj;
        return Objects.equals(this.metricSetArn(), other.metricSetArn()) && this.hasDataQualityMetricList() == other.hasDataQualityMetricList() && Objects.equals(this.dataQualityMetricList(), other.dataQualityMetricList());
    }

    public final String toString() {
        return ToString.builder((String)"MetricSetDataQualityMetric").add("MetricSetArn", (Object)this.metricSetArn()).add("DataQualityMetricList", this.hasDataQualityMetricList() ? this.dataQualityMetricList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSetArn": {
                return Optional.ofNullable(clazz.cast(this.metricSetArn()));
            }
            case "DataQualityMetricList": {
                return Optional.ofNullable(clazz.cast(this.dataQualityMetricList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricSetArn", METRIC_SET_ARN_FIELD);
        map.put("DataQualityMetricList", DATA_QUALITY_METRIC_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSetDataQualityMetric, T> g) {
        return obj -> g.apply((MetricSetDataQualityMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricSetArn;
        private List<DataQualityMetric> dataQualityMetricList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSetDataQualityMetric model) {
            this.metricSetArn(model.metricSetArn);
            this.dataQualityMetricList(model.dataQualityMetricList);
        }

        public final String getMetricSetArn() {
            return this.metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final List<DataQualityMetric.Builder> getDataQualityMetricList() {
            List<DataQualityMetric.Builder> result = DataQualityMetricListCopier.copyToBuilder(this.dataQualityMetricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataQualityMetricList(Collection<DataQualityMetric.BuilderImpl> dataQualityMetricList) {
            this.dataQualityMetricList = DataQualityMetricListCopier.copyFromBuilder(dataQualityMetricList);
        }

        @Override
        public final Builder dataQualityMetricList(Collection<DataQualityMetric> dataQualityMetricList) {
            this.dataQualityMetricList = DataQualityMetricListCopier.copy(dataQualityMetricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataQualityMetricList(DataQualityMetric ... dataQualityMetricList) {
            this.dataQualityMetricList(Arrays.asList(dataQualityMetricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataQualityMetricList(Consumer<DataQualityMetric.Builder> ... dataQualityMetricList) {
            this.dataQualityMetricList(Stream.of(dataQualityMetricList).map(c -> (DataQualityMetric)((DataQualityMetric.Builder)DataQualityMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricSetDataQualityMetric build() {
            return new MetricSetDataQualityMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricSetDataQualityMetric> {
        public Builder metricSetArn(String var1);

        public Builder dataQualityMetricList(Collection<DataQualityMetric> var1);

        public Builder dataQualityMetricList(DataQualityMetric ... var1);

        public Builder dataQualityMetricList(Consumer<DataQualityMetric.Builder> ... var1);
    }
}

