/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppFlowConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppFlowConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AppFlowConfig.getter(AppFlowConfig::roleArn)).setter(AppFlowConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowName").getter(AppFlowConfig.getter(AppFlowConfig::flowName)).setter(AppFlowConfig.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, FLOW_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppFlowConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String flowName;

    private AppFlowConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.flowName = builder.flowName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String flowName() {
        return this.flowName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppFlowConfig)) {
            return false;
        }
        AppFlowConfig other = (AppFlowConfig)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.flowName(), other.flowName());
    }

    public final String toString() {
        return ToString.builder((String)"AppFlowConfig").add("RoleArn", (Object)this.roleArn()).add("FlowName", (Object)this.flowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "FlowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("FlowName", FLOW_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppFlowConfig, T> g) {
        return obj -> g.apply((AppFlowConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String flowName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppFlowConfig model) {
            this.roleArn(model.roleArn);
            this.flowName(model.flowName);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public AppFlowConfig build() {
            return new AppFlowConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppFlowConfig> {
        public Builder roleArn(String var1);

        public Builder flowName(String var1);
    }
}

