/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.BackTestConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AthenaSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AthenaSourceConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AthenaSourceConfig.getter(AthenaSourceConfig::roleArn)).setter(AthenaSourceConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(AthenaSourceConfig.getter(AthenaSourceConfig::databaseName)).setter(AthenaSourceConfig.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DATA_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCatalog").getter(AthenaSourceConfig.getter(AthenaSourceConfig::dataCatalog)).setter(AthenaSourceConfig.setter(Builder::dataCatalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalog").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(AthenaSourceConfig.getter(AthenaSourceConfig::tableName)).setter(AthenaSourceConfig.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> WORK_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroupName").getter(AthenaSourceConfig.getter(AthenaSourceConfig::workGroupName)).setter(AthenaSourceConfig.setter(Builder::workGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroupName").build()}).build();
    private static final SdkField<String> S3_RESULTS_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ResultsPath").getter(AthenaSourceConfig.getter(AthenaSourceConfig::s3ResultsPath)).setter(AthenaSourceConfig.setter(Builder::s3ResultsPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ResultsPath").build()}).build();
    private static final SdkField<BackTestConfiguration> BACK_TEST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackTestConfiguration").getter(AthenaSourceConfig.getter(AthenaSourceConfig::backTestConfiguration)).setter(AthenaSourceConfig.setter(Builder::backTestConfiguration)).constructor(BackTestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackTestConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DATABASE_NAME_FIELD, DATA_CATALOG_FIELD, TABLE_NAME_FIELD, WORK_GROUP_NAME_FIELD, S3_RESULTS_PATH_FIELD, BACK_TEST_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AthenaSourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String databaseName;
    private final String dataCatalog;
    private final String tableName;
    private final String workGroupName;
    private final String s3ResultsPath;
    private final BackTestConfiguration backTestConfiguration;

    private AthenaSourceConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.databaseName = builder.databaseName;
        this.dataCatalog = builder.dataCatalog;
        this.tableName = builder.tableName;
        this.workGroupName = builder.workGroupName;
        this.s3ResultsPath = builder.s3ResultsPath;
        this.backTestConfiguration = builder.backTestConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dataCatalog() {
        return this.dataCatalog;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String workGroupName() {
        return this.workGroupName;
    }

    public final String s3ResultsPath() {
        return this.s3ResultsPath;
    }

    public final BackTestConfiguration backTestConfiguration() {
        return this.backTestConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ResultsPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.backTestConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaSourceConfig)) {
            return false;
        }
        AthenaSourceConfig other = (AthenaSourceConfig)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dataCatalog(), other.dataCatalog()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.workGroupName(), other.workGroupName()) && Objects.equals(this.s3ResultsPath(), other.s3ResultsPath()) && Objects.equals(this.backTestConfiguration(), other.backTestConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AthenaSourceConfig").add("RoleArn", (Object)this.roleArn()).add("DatabaseName", (Object)this.databaseName()).add("DataCatalog", (Object)this.dataCatalog()).add("TableName", (Object)this.tableName()).add("WorkGroupName", (Object)this.workGroupName()).add("S3ResultsPath", (Object)this.s3ResultsPath()).add("BackTestConfiguration", (Object)this.backTestConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DataCatalog": {
                return Optional.ofNullable(clazz.cast(this.dataCatalog()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "WorkGroupName": {
                return Optional.ofNullable(clazz.cast(this.workGroupName()));
            }
            case "S3ResultsPath": {
                return Optional.ofNullable(clazz.cast(this.s3ResultsPath()));
            }
            case "BackTestConfiguration": {
                return Optional.ofNullable(clazz.cast(this.backTestConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("DataCatalog", DATA_CATALOG_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("WorkGroupName", WORK_GROUP_NAME_FIELD);
        map.put("S3ResultsPath", S3_RESULTS_PATH_FIELD);
        map.put("BackTestConfiguration", BACK_TEST_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AthenaSourceConfig, T> g) {
        return obj -> g.apply((AthenaSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String databaseName;
        private String dataCatalog;
        private String tableName;
        private String workGroupName;
        private String s3ResultsPath;
        private BackTestConfiguration backTestConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaSourceConfig model) {
            this.roleArn(model.roleArn);
            this.databaseName(model.databaseName);
            this.dataCatalog(model.dataCatalog);
            this.tableName(model.tableName);
            this.workGroupName(model.workGroupName);
            this.s3ResultsPath(model.s3ResultsPath);
            this.backTestConfiguration(model.backTestConfiguration);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDataCatalog() {
            return this.dataCatalog;
        }

        public final void setDataCatalog(String dataCatalog) {
            this.dataCatalog = dataCatalog;
        }

        @Override
        public final Builder dataCatalog(String dataCatalog) {
            this.dataCatalog = dataCatalog;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getWorkGroupName() {
            return this.workGroupName;
        }

        public final void setWorkGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
        }

        @Override
        public final Builder workGroupName(String workGroupName) {
            this.workGroupName = workGroupName;
            return this;
        }

        public final String getS3ResultsPath() {
            return this.s3ResultsPath;
        }

        public final void setS3ResultsPath(String s3ResultsPath) {
            this.s3ResultsPath = s3ResultsPath;
        }

        @Override
        public final Builder s3ResultsPath(String s3ResultsPath) {
            this.s3ResultsPath = s3ResultsPath;
            return this;
        }

        public final BackTestConfiguration.Builder getBackTestConfiguration() {
            return this.backTestConfiguration != null ? this.backTestConfiguration.toBuilder() : null;
        }

        public final void setBackTestConfiguration(BackTestConfiguration.BuilderImpl backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration != null ? backTestConfiguration.build() : null;
        }

        @Override
        public final Builder backTestConfiguration(BackTestConfiguration backTestConfiguration) {
            this.backTestConfiguration = backTestConfiguration;
            return this;
        }

        public AthenaSourceConfig build() {
            return new AthenaSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AthenaSourceConfig> {
        public Builder roleArn(String var1);

        public Builder databaseName(String var1);

        public Builder dataCatalog(String var1);

        public Builder tableName(String var1);

        public Builder workGroupName(String var1);

        public Builder s3ResultsPath(String var1);

        public Builder backTestConfiguration(BackTestConfiguration var1);

        default public Builder backTestConfiguration(Consumer<BackTestConfiguration.Builder> backTestConfiguration) {
            return this.backTestConfiguration((BackTestConfiguration)((BackTestConfiguration.Builder)BackTestConfiguration.builder().applyMutation(backTestConfiguration)).build());
        }
    }
}

