/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelPackagingJobsResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<ListModelPackagingJobsResponse.Builder, ListModelPackagingJobsResponse> {
    private static final SdkField<List<ModelPackagingJobMetadata>> MODEL_PACKAGING_JOBS_FIELD = SdkField
            .<List<ModelPackagingJobMetadata>> builder(MarshallingType.LIST)
            .memberName("ModelPackagingJobs")
            .getter(getter(ListModelPackagingJobsResponse::modelPackagingJobs))
            .setter(setter(Builder::modelPackagingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackagingJobMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackagingJobMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelPackagingJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGING_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ModelPackagingJobMetadata> modelPackagingJobs;

    private final String nextToken;

    private ListModelPackagingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackagingJobs = builder.modelPackagingJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelPackagingJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelPackagingJobs() {
        return modelPackagingJobs != null && !(modelPackagingJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelPackagingJobs} method.
     * </p>
     * 
     * @return A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
     */
    public final List<ModelPackagingJobMetadata> modelPackagingJobs() {
        return modelPackagingJobs;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision
     * returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for
     *         Vision returns a pagination token in the response. You can use this pagination token to retrieve the next
     *         set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelPackagingJobs() ? modelPackagingJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelPackagingJobsResponse)) {
            return false;
        }
        ListModelPackagingJobsResponse other = (ListModelPackagingJobsResponse) obj;
        return hasModelPackagingJobs() == other.hasModelPackagingJobs()
                && Objects.equals(modelPackagingJobs(), other.modelPackagingJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelPackagingJobsResponse")
                .add("ModelPackagingJobs", hasModelPackagingJobs() ? modelPackagingJobs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackagingJobs":
            return Optional.ofNullable(clazz.cast(modelPackagingJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelPackagingJobsResponse, T> g) {
        return obj -> g.apply((ListModelPackagingJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelPackagingJobsResponse> {
        /**
         * <p>
         * A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
         * </p>
         * 
         * @param modelPackagingJobs
         *        A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingJobs(Collection<ModelPackagingJobMetadata> modelPackagingJobs);

        /**
         * <p>
         * A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
         * </p>
         * 
         * @param modelPackagingJobs
         *        A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingJobs(ModelPackagingJobMetadata... modelPackagingJobs);

        /**
         * <p>
         * A list of the model packaging jobs created for the specified Amazon Lookout for Vision project.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelPackagingJobMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<ModelPackagingJobMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelPackagingJobMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #modelPackagingJobs(List<ModelPackagingJobMetadata>)}.
         * 
         * @param modelPackagingJobs
         *        a consumer that will call methods on {@link List<ModelPackagingJobMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackagingJobs(List<ModelPackagingJobMetadata>)
         */
        Builder modelPackagingJobs(Consumer<ModelPackagingJobMetadata.Builder>... modelPackagingJobs);

        /**
         * <p>
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for
         * Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set
         * of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout
         *        for Vision returns a pagination token in the response. You can use this pagination token to retrieve
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private List<ModelPackagingJobMetadata> modelPackagingJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelPackagingJobsResponse model) {
            super(model);
            modelPackagingJobs(model.modelPackagingJobs);
            nextToken(model.nextToken);
        }

        public final List<ModelPackagingJobMetadata.Builder> getModelPackagingJobs() {
            List<ModelPackagingJobMetadata.Builder> result = ModelPackagingJobsListCopier.copyToBuilder(this.modelPackagingJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelPackagingJobs(Collection<ModelPackagingJobMetadata.BuilderImpl> modelPackagingJobs) {
            this.modelPackagingJobs = ModelPackagingJobsListCopier.copyFromBuilder(modelPackagingJobs);
        }

        @Override
        @Transient
        public final Builder modelPackagingJobs(Collection<ModelPackagingJobMetadata> modelPackagingJobs) {
            this.modelPackagingJobs = ModelPackagingJobsListCopier.copy(modelPackagingJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelPackagingJobs(ModelPackagingJobMetadata... modelPackagingJobs) {
            modelPackagingJobs(Arrays.asList(modelPackagingJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelPackagingJobs(Consumer<ModelPackagingJobMetadata.Builder>... modelPackagingJobs) {
            modelPackagingJobs(Stream.of(modelPackagingJobs)
                    .map(c -> ModelPackagingJobMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelPackagingJobsResponse build() {
            return new ListModelPackagingJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
