/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartModelPackagingJobRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<StartModelPackagingJobRequest.Builder, StartModelPackagingJobRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(StartModelPackagingJobRequest::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(StartModelPackagingJobRequest::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(StartModelPackagingJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<ModelPackagingConfiguration> CONFIGURATION_FIELD = SdkField
            .<ModelPackagingConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(StartModelPackagingJobRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ModelPackagingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartModelPackagingJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartModelPackagingJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            MODEL_VERSION_FIELD, JOB_NAME_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String projectName;

    private final String modelVersion;

    private final String jobName;

    private final ModelPackagingConfiguration configuration;

    private final String description;

    private final String clientToken;

    private StartModelPackagingJobRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.modelVersion = builder.modelVersion;
        this.jobName = builder.jobName;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the project which contains the version of the model that you want to package.
     * </p>
     * 
     * @return The name of the project which contains the version of the model that you want to package.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The version of the model within the project that you want to package.
     * </p>
     * 
     * @return The version of the model within the project that you want to package.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * A name for the model packaging job. If you don't supply a value, the service creates a job name for you.
     * </p>
     * 
     * @return A name for the model packaging job. If you don't supply a value, the service creates a job name for you.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The configuration for the model packaging job.
     * </p>
     * 
     * @return The configuration for the model packaging job.
     */
    public final ModelPackagingConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * A description for the model packaging job.
     * </p>
     * 
     * @return A description for the model packaging job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only
     * once. You choose the value to pass. For example, An issue might prevent you from getting a response from
     * <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code>
     * by using the same <code>ClientToken</code> parameter value.
     * </p>
     * <p>
     * If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This
     * prevents retries after a network error from making multiple dataset creation requests. You'll need to provide
     * your own value for other use cases.
     * </p>
     * <p>
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value
     * for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency
     * token is active for 8 hours.
     * </p>
     * 
     * @return ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes
     *         only once. You choose the value to pass. For example, An issue might prevent you from getting a response
     *         from <code>StartModelPackagingJob</code>. In this case, safely retry your call to
     *         <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
     *         <p>
     *         If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for
     *         you. This prevents retries after a network error from making multiple dataset creation requests. You'll
     *         need to provide your own value for other use cases.
     *         </p>
     *         <p>
     *         An error occurs if the other input parameters are not the same as in the first request. Using a different
     *         value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An
     *         idempotency token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartModelPackagingJobRequest)) {
            return false;
        }
        StartModelPackagingJobRequest other = (StartModelPackagingJobRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartModelPackagingJobRequest").add("ProjectName", projectName())
                .add("ModelVersion", modelVersion()).add("JobName", jobName()).add("Configuration", configuration())
                .add("Description", description()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartModelPackagingJobRequest, T> g) {
        return obj -> g.apply((StartModelPackagingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartModelPackagingJobRequest> {
        /**
         * <p>
         * The name of the project which contains the version of the model that you want to package.
         * </p>
         * 
         * @param projectName
         *        The name of the project which contains the version of the model that you want to package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The version of the model within the project that you want to package.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model within the project that you want to package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * A name for the model packaging job. If you don't supply a value, the service creates a job name for you.
         * </p>
         * 
         * @param jobName
         *        A name for the model packaging job. If you don't supply a value, the service creates a job name for
         *        you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The configuration for the model packaging job.
         * </p>
         * 
         * @param configuration
         *        The configuration for the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ModelPackagingConfiguration configuration);

        /**
         * <p>
         * The configuration for the model packaging job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelPackagingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ModelPackagingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackagingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(ModelPackagingConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ModelPackagingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ModelPackagingConfiguration)
         */
        default Builder configuration(Consumer<ModelPackagingConfiguration.Builder> configuration) {
            return configuration(ModelPackagingConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A description for the model packaging job.
         * </p>
         * 
         * @param description
         *        A description for the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only
         * once. You choose the value to pass. For example, An issue might prevent you from getting a response from
         * <code>StartModelPackagingJob</code>. In this case, safely retry your call to
         * <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.
         * </p>
         * <p>
         * If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you.
         * This prevents retries after a network error from making multiple dataset creation requests. You'll need to
         * provide your own value for other use cases.
         * </p>
         * <p>
         * An error occurs if the other input parameters are not the same as in the first request. Using a different
         * value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An
         * idempotency token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code>
         *        completes only once. You choose the value to pass. For example, An issue might prevent you from
         *        getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to
         *        <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
         *        <p>
         *        If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value
         *        for you. This prevents retries after a network error from making multiple dataset creation requests.
         *        You'll need to provide your own value for other use cases.
         *        </p>
         *        <p>
         *        An error occurs if the other input parameters are not the same as in the first request. Using a
         *        different value for <code>ClientToken</code> is considered a new call to
         *        <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String modelVersion;

        private String jobName;

        private ModelPackagingConfiguration configuration;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartModelPackagingJobRequest model) {
            super(model);
            projectName(model.projectName);
            modelVersion(model.modelVersion);
            jobName(model.jobName);
            configuration(model.configuration);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final ModelPackagingConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ModelPackagingConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(ModelPackagingConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartModelPackagingJobRequest build() {
            return new StartModelPackagingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
