/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase;
import software.amazon.awssdk.services.machinelearning.model.RedshiftDatabaseCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDataSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDataSpec> {
    private static final SdkField<RedshiftDatabase> DATABASE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseInformation").getter(RedshiftDataSpec.getter(RedshiftDataSpec::databaseInformation)).setter(RedshiftDataSpec.setter(Builder::databaseInformation)).constructor(RedshiftDatabase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInformation").build()}).build();
    private static final SdkField<String> SELECT_SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectSqlQuery").getter(RedshiftDataSpec.getter(RedshiftDataSpec::selectSqlQuery)).setter(RedshiftDataSpec.setter(Builder::selectSqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectSqlQuery").build()}).build();
    private static final SdkField<RedshiftDatabaseCredentials> DATABASE_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseCredentials").getter(RedshiftDataSpec.getter(RedshiftDataSpec::databaseCredentials)).setter(RedshiftDataSpec.setter(Builder::databaseCredentials)).constructor(RedshiftDatabaseCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseCredentials").build()}).build();
    private static final SdkField<String> S3_STAGING_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3StagingLocation").getter(RedshiftDataSpec.getter(RedshiftDataSpec::s3StagingLocation)).setter(RedshiftDataSpec.setter(Builder::s3StagingLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StagingLocation").build()}).build();
    private static final SdkField<String> DATA_REARRANGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRearrangement").getter(RedshiftDataSpec.getter(RedshiftDataSpec::dataRearrangement)).setter(RedshiftDataSpec.setter(Builder::dataRearrangement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRearrangement").build()}).build();
    private static final SdkField<String> DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSchema").getter(RedshiftDataSpec.getter(RedshiftDataSpec::dataSchema)).setter(RedshiftDataSpec.setter(Builder::dataSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSchema").build()}).build();
    private static final SdkField<String> DATA_SCHEMA_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSchemaUri").getter(RedshiftDataSpec.getter(RedshiftDataSpec::dataSchemaUri)).setter(RedshiftDataSpec.setter(Builder::dataSchemaUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSchemaUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_INFORMATION_FIELD, SELECT_SQL_QUERY_FIELD, DATABASE_CREDENTIALS_FIELD, S3_STAGING_LOCATION_FIELD, DATA_REARRANGEMENT_FIELD, DATA_SCHEMA_FIELD, DATA_SCHEMA_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftDataSpec.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftDatabase databaseInformation;
    private final String selectSqlQuery;
    private final RedshiftDatabaseCredentials databaseCredentials;
    private final String s3StagingLocation;
    private final String dataRearrangement;
    private final String dataSchema;
    private final String dataSchemaUri;

    private RedshiftDataSpec(BuilderImpl builder) {
        this.databaseInformation = builder.databaseInformation;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.databaseCredentials = builder.databaseCredentials;
        this.s3StagingLocation = builder.s3StagingLocation;
        this.dataRearrangement = builder.dataRearrangement;
        this.dataSchema = builder.dataSchema;
        this.dataSchemaUri = builder.dataSchemaUri;
    }

    public final RedshiftDatabase databaseInformation() {
        return this.databaseInformation;
    }

    public final String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public final RedshiftDatabaseCredentials databaseCredentials() {
        return this.databaseCredentials;
    }

    public final String s3StagingLocation() {
        return this.s3StagingLocation;
    }

    public final String dataRearrangement() {
        return this.dataRearrangement;
    }

    public final String dataSchema() {
        return this.dataSchema;
    }

    public final String dataSchemaUri() {
        return this.dataSchemaUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StagingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRearrangement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSchemaUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataSpec)) {
            return false;
        }
        RedshiftDataSpec other = (RedshiftDataSpec)obj;
        return Objects.equals(this.databaseInformation(), other.databaseInformation()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery()) && Objects.equals(this.databaseCredentials(), other.databaseCredentials()) && Objects.equals(this.s3StagingLocation(), other.s3StagingLocation()) && Objects.equals(this.dataRearrangement(), other.dataRearrangement()) && Objects.equals(this.dataSchema(), other.dataSchema()) && Objects.equals(this.dataSchemaUri(), other.dataSchemaUri());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftDataSpec").add("DatabaseInformation", (Object)this.databaseInformation()).add("SelectSqlQuery", (Object)this.selectSqlQuery()).add("DatabaseCredentials", (Object)this.databaseCredentials()).add("S3StagingLocation", (Object)this.s3StagingLocation()).add("DataRearrangement", (Object)this.dataRearrangement()).add("DataSchema", (Object)this.dataSchema()).add("DataSchemaUri", (Object)this.dataSchemaUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseInformation": {
                return Optional.ofNullable(clazz.cast(this.databaseInformation()));
            }
            case "SelectSqlQuery": {
                return Optional.ofNullable(clazz.cast(this.selectSqlQuery()));
            }
            case "DatabaseCredentials": {
                return Optional.ofNullable(clazz.cast(this.databaseCredentials()));
            }
            case "S3StagingLocation": {
                return Optional.ofNullable(clazz.cast(this.s3StagingLocation()));
            }
            case "DataRearrangement": {
                return Optional.ofNullable(clazz.cast(this.dataRearrangement()));
            }
            case "DataSchema": {
                return Optional.ofNullable(clazz.cast(this.dataSchema()));
            }
            case "DataSchemaUri": {
                return Optional.ofNullable(clazz.cast(this.dataSchemaUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseInformation", DATABASE_INFORMATION_FIELD);
        map.put("SelectSqlQuery", SELECT_SQL_QUERY_FIELD);
        map.put("DatabaseCredentials", DATABASE_CREDENTIALS_FIELD);
        map.put("S3StagingLocation", S3_STAGING_LOCATION_FIELD);
        map.put("DataRearrangement", DATA_REARRANGEMENT_FIELD);
        map.put("DataSchema", DATA_SCHEMA_FIELD);
        map.put("DataSchemaUri", DATA_SCHEMA_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataSpec, T> g) {
        return obj -> g.apply((RedshiftDataSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDatabase databaseInformation;
        private String selectSqlQuery;
        private RedshiftDatabaseCredentials databaseCredentials;
        private String s3StagingLocation;
        private String dataRearrangement;
        private String dataSchema;
        private String dataSchemaUri;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataSpec model) {
            this.databaseInformation(model.databaseInformation);
            this.selectSqlQuery(model.selectSqlQuery);
            this.databaseCredentials(model.databaseCredentials);
            this.s3StagingLocation(model.s3StagingLocation);
            this.dataRearrangement(model.dataRearrangement);
            this.dataSchema(model.dataSchema);
            this.dataSchemaUri(model.dataSchemaUri);
        }

        public final RedshiftDatabase.Builder getDatabaseInformation() {
            return this.databaseInformation != null ? this.databaseInformation.toBuilder() : null;
        }

        public final void setDatabaseInformation(RedshiftDatabase.BuilderImpl databaseInformation) {
            this.databaseInformation = databaseInformation != null ? databaseInformation.build() : null;
        }

        @Override
        public final Builder databaseInformation(RedshiftDatabase databaseInformation) {
            this.databaseInformation = databaseInformation;
            return this;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final RedshiftDatabaseCredentials.Builder getDatabaseCredentials() {
            return this.databaseCredentials != null ? this.databaseCredentials.toBuilder() : null;
        }

        public final void setDatabaseCredentials(RedshiftDatabaseCredentials.BuilderImpl databaseCredentials) {
            this.databaseCredentials = databaseCredentials != null ? databaseCredentials.build() : null;
        }

        @Override
        public final Builder databaseCredentials(RedshiftDatabaseCredentials databaseCredentials) {
            this.databaseCredentials = databaseCredentials;
            return this;
        }

        public final String getS3StagingLocation() {
            return this.s3StagingLocation;
        }

        public final void setS3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
        }

        @Override
        public final Builder s3StagingLocation(String s3StagingLocation) {
            this.s3StagingLocation = s3StagingLocation;
            return this;
        }

        public final String getDataRearrangement() {
            return this.dataRearrangement;
        }

        public final void setDataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
        }

        @Override
        public final Builder dataRearrangement(String dataRearrangement) {
            this.dataRearrangement = dataRearrangement;
            return this;
        }

        public final String getDataSchema() {
            return this.dataSchema;
        }

        public final void setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
        }

        @Override
        public final Builder dataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public final String getDataSchemaUri() {
            return this.dataSchemaUri;
        }

        public final void setDataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
        }

        @Override
        public final Builder dataSchemaUri(String dataSchemaUri) {
            this.dataSchemaUri = dataSchemaUri;
            return this;
        }

        public RedshiftDataSpec build() {
            return new RedshiftDataSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDataSpec> {
        public Builder databaseInformation(RedshiftDatabase var1);

        default public Builder databaseInformation(Consumer<RedshiftDatabase.Builder> databaseInformation) {
            return this.databaseInformation((RedshiftDatabase)((RedshiftDatabase.Builder)RedshiftDatabase.builder().applyMutation(databaseInformation)).build());
        }

        public Builder selectSqlQuery(String var1);

        public Builder databaseCredentials(RedshiftDatabaseCredentials var1);

        default public Builder databaseCredentials(Consumer<RedshiftDatabaseCredentials.Builder> databaseCredentials) {
            return this.databaseCredentials((RedshiftDatabaseCredentials)((RedshiftDatabaseCredentials.Builder)RedshiftDatabaseCredentials.builder().applyMutation(databaseCredentials)).build());
        }

        public Builder s3StagingLocation(String var1);

        public Builder dataRearrangement(String var1);

        public Builder dataSchema(String var1);

        public Builder dataSchemaUri(String var1);
    }
}

