/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a property- or tag-based condition that defines criteria for including or excluding S3 buckets from a
 * classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CriteriaForJob implements SdkPojo, Serializable, ToCopyableBuilder<CriteriaForJob.Builder, CriteriaForJob> {
    private static final SdkField<SimpleCriterionForJob> SIMPLE_CRITERION_FIELD = SdkField
            .<SimpleCriterionForJob> builder(MarshallingType.SDK_POJO).memberName("simpleCriterion")
            .getter(getter(CriteriaForJob::simpleCriterion)).setter(setter(Builder::simpleCriterion))
            .constructor(SimpleCriterionForJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simpleCriterion").build()).build();

    private static final SdkField<TagCriterionForJob> TAG_CRITERION_FIELD = SdkField
            .<TagCriterionForJob> builder(MarshallingType.SDK_POJO).memberName("tagCriterion")
            .getter(getter(CriteriaForJob::tagCriterion)).setter(setter(Builder::tagCriterion))
            .constructor(TagCriterionForJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagCriterion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_CRITERION_FIELD,
            TAG_CRITERION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimpleCriterionForJob simpleCriterion;

    private final TagCriterionForJob tagCriterion;

    private CriteriaForJob(BuilderImpl builder) {
        this.simpleCriterion = builder.simpleCriterion;
        this.tagCriterion = builder.tagCriterion;
    }

    /**
     * <p>
     * A property-based condition that defines a property, operator, and one or more values for including or excluding
     * buckets from the job.
     * </p>
     * 
     * @return A property-based condition that defines a property, operator, and one or more values for including or
     *         excluding buckets from the job.
     */
    public final SimpleCriterionForJob simpleCriterion() {
        return simpleCriterion;
    }

    /**
     * <p>
     * A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including
     * or excluding buckets from the job.
     * </p>
     * 
     * @return A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for
     *         including or excluding buckets from the job.
     */
    public final TagCriterionForJob tagCriterion() {
        return tagCriterion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleCriterion());
        hashCode = 31 * hashCode + Objects.hashCode(tagCriterion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CriteriaForJob)) {
            return false;
        }
        CriteriaForJob other = (CriteriaForJob) obj;
        return Objects.equals(simpleCriterion(), other.simpleCriterion()) && Objects.equals(tagCriterion(), other.tagCriterion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CriteriaForJob").add("SimpleCriterion", simpleCriterion()).add("TagCriterion", tagCriterion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "simpleCriterion":
            return Optional.ofNullable(clazz.cast(simpleCriterion()));
        case "tagCriterion":
            return Optional.ofNullable(clazz.cast(tagCriterion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CriteriaForJob, T> g) {
        return obj -> g.apply((CriteriaForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CriteriaForJob> {
        /**
         * <p>
         * A property-based condition that defines a property, operator, and one or more values for including or
         * excluding buckets from the job.
         * </p>
         * 
         * @param simpleCriterion
         *        A property-based condition that defines a property, operator, and one or more values for including or
         *        excluding buckets from the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleCriterion(SimpleCriterionForJob simpleCriterion);

        /**
         * <p>
         * A property-based condition that defines a property, operator, and one or more values for including or
         * excluding buckets from the job.
         * </p>
         * This is a convenience that creates an instance of the {@link SimpleCriterionForJob.Builder} avoiding the need
         * to create one manually via {@link SimpleCriterionForJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleCriterionForJob.Builder#build()} is called immediately and
         * its result is passed to {@link #simpleCriterion(SimpleCriterionForJob)}.
         * 
         * @param simpleCriterion
         *        a consumer that will call methods on {@link SimpleCriterionForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleCriterion(SimpleCriterionForJob)
         */
        default Builder simpleCriterion(Consumer<SimpleCriterionForJob.Builder> simpleCriterion) {
            return simpleCriterion(SimpleCriterionForJob.builder().applyMutation(simpleCriterion).build());
        }

        /**
         * <p>
         * A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for
         * including or excluding buckets from the job.
         * </p>
         * 
         * @param tagCriterion
         *        A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs
         *        for including or excluding buckets from the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagCriterion(TagCriterionForJob tagCriterion);

        /**
         * <p>
         * A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for
         * including or excluding buckets from the job.
         * </p>
         * This is a convenience that creates an instance of the {@link TagCriterionForJob.Builder} avoiding the need to
         * create one manually via {@link TagCriterionForJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagCriterionForJob.Builder#build()} is called immediately and its
         * result is passed to {@link #tagCriterion(TagCriterionForJob)}.
         * 
         * @param tagCriterion
         *        a consumer that will call methods on {@link TagCriterionForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagCriterion(TagCriterionForJob)
         */
        default Builder tagCriterion(Consumer<TagCriterionForJob.Builder> tagCriterion) {
            return tagCriterion(TagCriterionForJob.builder().applyMutation(tagCriterion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SimpleCriterionForJob simpleCriterion;

        private TagCriterionForJob tagCriterion;

        private BuilderImpl() {
        }

        private BuilderImpl(CriteriaForJob model) {
            simpleCriterion(model.simpleCriterion);
            tagCriterion(model.tagCriterion);
        }

        public final SimpleCriterionForJob.Builder getSimpleCriterion() {
            return simpleCriterion != null ? simpleCriterion.toBuilder() : null;
        }

        public final void setSimpleCriterion(SimpleCriterionForJob.BuilderImpl simpleCriterion) {
            this.simpleCriterion = simpleCriterion != null ? simpleCriterion.build() : null;
        }

        @Override
        @Transient
        public final Builder simpleCriterion(SimpleCriterionForJob simpleCriterion) {
            this.simpleCriterion = simpleCriterion;
            return this;
        }

        public final TagCriterionForJob.Builder getTagCriterion() {
            return tagCriterion != null ? tagCriterion.toBuilder() : null;
        }

        public final void setTagCriterion(TagCriterionForJob.BuilderImpl tagCriterion) {
            this.tagCriterion = tagCriterion != null ? tagCriterion.build() : null;
        }

        @Override
        @Transient
        public final Builder tagCriterion(TagCriterionForJob tagCriterion) {
            this.tagCriterion = tagCriterion;
            return this;
        }

        @Override
        public CriteriaForJob build() {
            return new CriteriaForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
