/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMacieSessionResponse extends Macie2Response implements
        ToCopyableBuilder<GetMacieSessionResponse.Builder, GetMacieSessionResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetMacieSessionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("findingPublishingFrequency")
            .getter(getter(GetMacieSessionResponse::findingPublishingFrequencyAsString))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build())
            .build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(GetMacieSessionResponse::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetMacieSessionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetMacieSessionResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            FINDING_PUBLISHING_FREQUENCY_FIELD, SERVICE_ROLE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private final Instant createdAt;

    private final String findingPublishingFrequency;

    private final String serviceRole;

    private final String status;

    private final Instant updatedAt;

    private GetMacieSessionResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes
     * publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes
     *         publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * @see FindingPublishingFrequency
     */
    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(findingPublishingFrequency);
    }

    /**
     * <p>
     * The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes
     * publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes
     *         publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * @see FindingPublishingFrequency
     */
    public final String findingPublishingFrequencyAsString() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service-linked role that allows Amazon Macie to monitor and analyze data in
     * Amazon Web Services resources for the account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service-linked role that allows Amazon Macie to monitor and analyze
     *         data in Amazon Web Services resources for the account.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but all Macie
     * activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities
     * are enabled for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MacieStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but
     *         all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all
     *         Macie activities are enabled for the account.
     * @see MacieStatus
     */
    public final MacieStatus status() {
        return MacieStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but all Macie
     * activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities
     * are enabled for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MacieStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but
     *         all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all
     *         Macie activities are enabled for the account.
     * @see MacieStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the Amazon
     * Macie account.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the
     *         Amazon Macie account.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMacieSessionResponse)) {
            return false;
        }
        GetMacieSessionResponse other = (GetMacieSessionResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMacieSessionResponse").add("CreatedAt", createdAt())
                .add("FindingPublishingFrequency", findingPublishingFrequencyAsString()).add("ServiceRole", serviceRole())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "findingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequencyAsString()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMacieSessionResponse, T> g) {
        return obj -> g.apply((GetMacieSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetMacieSessionResponse> {
        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes
         * publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The frequency with which Amazon Macie publishes updates to policy findings for the account. This
         *        includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch
         *        Events).
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes
         * publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The frequency with which Amazon Macie publishes updates to policy findings for the account. This
         *        includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch
         *        Events).
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service-linked role that allows Amazon Macie to monitor and analyze
         * data in Amazon Web Services resources for the account.
         * </p>
         * 
         * @param serviceRole
         *        The Amazon Resource Name (ARN) of the service-linked role that allows Amazon Macie to monitor and
         *        analyze data in Amazon Web Services resources for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but all
         * Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie
         * activities are enabled for the account.
         * </p>
         * 
         * @param status
         *        The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled
         *        but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled
         *        and all Macie activities are enabled for the account.
         * @see MacieStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacieStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but all
         * Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie
         * activities are enabled for the account.
         * </p>
         * 
         * @param status
         *        The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled
         *        but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled
         *        and all Macie activities are enabled for the account.
         * @see MacieStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacieStatus
         */
        Builder status(MacieStatus status);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the Amazon
         * Macie account.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the
         *        Amazon Macie account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private Instant createdAt;

        private String findingPublishingFrequency;

        private String serviceRole;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMacieSessionResponse model) {
            super(model);
            createdAt(model.createdAt);
            findingPublishingFrequency(model.findingPublishingFrequency);
            serviceRole(model.serviceRole);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        @Transient
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(MacieStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetMacieSessionResponse build() {
            return new GetMacieSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
