/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon Web Services account that owns S3 buckets for a classification job to analyze, and one or more
 * specific buckets to analyze for that account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketDefinitionForJob implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketDefinitionForJob.Builder, S3BucketDefinitionForJob> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(S3BucketDefinitionForJob::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<List<String>> BUCKETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("buckets")
            .getter(getter(S3BucketDefinitionForJob::buckets))
            .setter(setter(Builder::buckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUCKETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final List<String> buckets;

    private S3BucketDefinitionForJob(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.buckets = builder.buckets;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account that owns the buckets.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account that owns the buckets.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Buckets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuckets() {
        return buckets != null && !(buckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists the names of the buckets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuckets} method.
     * </p>
     * 
     * @return An array that lists the names of the buckets.
     */
    public final List<String> buckets() {
        return buckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBuckets() ? buckets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDefinitionForJob)) {
            return false;
        }
        S3BucketDefinitionForJob other = (S3BucketDefinitionForJob) obj;
        return Objects.equals(accountId(), other.accountId()) && hasBuckets() == other.hasBuckets()
                && Objects.equals(buckets(), other.buckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketDefinitionForJob").add("AccountId", accountId())
                .add("Buckets", hasBuckets() ? buckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "buckets":
            return Optional.ofNullable(clazz.cast(buckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketDefinitionForJob, T> g) {
        return obj -> g.apply((S3BucketDefinitionForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketDefinitionForJob> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account that owns the buckets.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account that owns the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An array that lists the names of the buckets.
         * </p>
         * 
         * @param buckets
         *        An array that lists the names of the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Collection<String> buckets);

        /**
         * <p>
         * An array that lists the names of the buckets.
         * </p>
         * 
         * @param buckets
         *        An array that lists the names of the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(String... buckets);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private List<String> buckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketDefinitionForJob model) {
            accountId(model.accountId);
            buckets(model.buckets);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getBuckets() {
            if (buckets instanceof SdkAutoConstructList) {
                return null;
            }
            return buckets;
        }

        public final void setBuckets(Collection<String> buckets) {
            this.buckets = ___listOf__stringCopier.copy(buckets);
        }

        @Override
        @Transient
        public final Builder buckets(Collection<String> buckets) {
            this.buckets = ___listOf__stringCopier.copy(buckets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder buckets(String... buckets) {
            buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        public S3BucketDefinitionForJob build() {
            return new S3BucketDefinitionForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
