/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedDiscoveryAccountUpdateError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedDiscoveryAccountUpdateError> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AutomatedDiscoveryAccountUpdateError.getter(AutomatedDiscoveryAccountUpdateError::accountId)).setter(AutomatedDiscoveryAccountUpdateError.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(AutomatedDiscoveryAccountUpdateError.getter(AutomatedDiscoveryAccountUpdateError::errorCodeAsString)).setter(AutomatedDiscoveryAccountUpdateError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ERROR_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedDiscoveryAccountUpdateError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String errorCode;

    private AutomatedDiscoveryAccountUpdateError(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.errorCode = builder.errorCode;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AutomatedDiscoveryAccountUpdateErrorCode errorCode() {
        return AutomatedDiscoveryAccountUpdateErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedDiscoveryAccountUpdateError)) {
            return false;
        }
        AutomatedDiscoveryAccountUpdateError other = (AutomatedDiscoveryAccountUpdateError)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedDiscoveryAccountUpdateError").add("AccountId", (Object)this.accountId()).add("ErrorCode", (Object)this.errorCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedDiscoveryAccountUpdateError, T> g) {
        return obj -> g.apply((AutomatedDiscoveryAccountUpdateError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedDiscoveryAccountUpdateError model) {
            this.accountId(model.accountId);
            this.errorCode(model.errorCode);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(AutomatedDiscoveryAccountUpdateErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public AutomatedDiscoveryAccountUpdateError build() {
            return new AutomatedDiscoveryAccountUpdateError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedDiscoveryAccountUpdateError> {
        public Builder accountId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(AutomatedDiscoveryAccountUpdateErrorCode var1);
    }
}

