/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.TimeRange;
import software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter;
import software.amazon.awssdk.services.macie2.model.UsageStatisticsSortBy;
import software.amazon.awssdk.services.macie2.model.___listOfUsageStatisticsFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsageStatisticsRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, GetUsageStatisticsRequest> {
    private static final SdkField<List<UsageStatisticsFilter>> FILTER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterBy").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::filterBy)).setter(GetUsageStatisticsRequest.setter(Builder::filterBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageStatisticsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::maxResults)).setter(GetUsageStatisticsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::nextToken)).setter(GetUsageStatisticsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<UsageStatisticsSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::sortBy)).setter(GetUsageStatisticsRequest.setter(Builder::sortBy)).constructor(UsageStatisticsSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeRange").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::timeRangeAsString)).setter(GetUsageStatisticsRequest.setter(Builder::timeRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, TIME_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUsageStatisticsRequest.memberNameToFieldInitializer();
    private final List<UsageStatisticsFilter> filterBy;
    private final Integer maxResults;
    private final String nextToken;
    private final UsageStatisticsSortBy sortBy;
    private final String timeRange;

    private GetUsageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.filterBy = builder.filterBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.timeRange = builder.timeRange;
    }

    public final boolean hasFilterBy() {
        return this.filterBy != null && !(this.filterBy instanceof SdkAutoConstructList);
    }

    public final List<UsageStatisticsFilter> filterBy() {
        return this.filterBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final UsageStatisticsSortBy sortBy() {
        return this.sortBy;
    }

    public final TimeRange timeRange() {
        return TimeRange.fromValue(this.timeRange);
    }

    public final String timeRangeAsString() {
        return this.timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterBy() ? this.filterBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsRequest)) {
            return false;
        }
        GetUsageStatisticsRequest other = (GetUsageStatisticsRequest)((Object)obj);
        return this.hasFilterBy() == other.hasFilterBy() && Objects.equals(this.filterBy(), other.filterBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.timeRangeAsString(), other.timeRangeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetUsageStatisticsRequest").add("FilterBy", this.hasFilterBy() ? this.filterBy() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortBy()).add("TimeRange", (Object)this.timeRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterBy": {
                return Optional.ofNullable(clazz.cast(this.filterBy()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "timeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRangeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterBy", FILTER_BY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("timeRange", TIME_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsRequest, T> g) {
        return obj -> g.apply((GetUsageStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private List<UsageStatisticsFilter> filterBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private UsageStatisticsSortBy sortBy;
        private String timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsRequest model) {
            super(model);
            this.filterBy(model.filterBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
            this.timeRange(model.timeRange);
        }

        public final List<UsageStatisticsFilter.Builder> getFilterBy() {
            List<UsageStatisticsFilter.Builder> result = ___listOfUsageStatisticsFilterCopier.copyToBuilder(this.filterBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterBy(Collection<UsageStatisticsFilter.BuilderImpl> filterBy) {
            this.filterBy = ___listOfUsageStatisticsFilterCopier.copyFromBuilder(filterBy);
        }

        @Override
        public final Builder filterBy(Collection<UsageStatisticsFilter> filterBy) {
            this.filterBy = ___listOfUsageStatisticsFilterCopier.copy(filterBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(UsageStatisticsFilter ... filterBy) {
            this.filterBy(Arrays.asList(filterBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBy(Consumer<UsageStatisticsFilter.Builder> ... filterBy) {
            this.filterBy(Stream.of(filterBy).map(c -> (UsageStatisticsFilter)((UsageStatisticsFilter.Builder)UsageStatisticsFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final UsageStatisticsSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(UsageStatisticsSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(UsageStatisticsSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final String getTimeRange() {
            return this.timeRange;
        }

        public final void setTimeRange(String timeRange) {
            this.timeRange = timeRange;
        }

        @Override
        public final Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange(timeRange == null ? null : timeRange.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsageStatisticsRequest build() {
            return new GetUsageStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUsageStatisticsRequest> {
        public Builder filterBy(Collection<UsageStatisticsFilter> var1);

        public Builder filterBy(UsageStatisticsFilter ... var1);

        public Builder filterBy(Consumer<UsageStatisticsFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortBy(UsageStatisticsSortBy var1);

        default public Builder sortBy(Consumer<UsageStatisticsSortBy.Builder> sortBy) {
            return this.sortBy((UsageStatisticsSortBy)((UsageStatisticsSortBy.Builder)UsageStatisticsSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder timeRange(String var1);

        public Builder timeRange(TimeRange var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

