/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorType {
    VALIDATION_EXCEPTION("VALIDATION_EXCEPTION"),
    RESOURCE_NOT_FOUND_EXCEPTION("RESOURCE_NOT_FOUND_EXCEPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorType> VALUE_MAP;
    private final String value;

    private ErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorType> knownValues() {
        EnumSet<ErrorType> knownValues = EnumSet.allOf(ErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorType.class, ErrorType::toString);
    }
}

