/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListFilteredTransactionEventsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent;

public class ListFilteredTransactionEventsIterable
implements SdkIterable<ListFilteredTransactionEventsResponse> {
    private final ManagedBlockchainQueryClient client;
    private final ListFilteredTransactionEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFilteredTransactionEventsIterable(ManagedBlockchainQueryClient client, ListFilteredTransactionEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFilteredTransactionEventsResponseFetcher();
    }

    public Iterator<ListFilteredTransactionEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransactionEvent> events() {
        Function<ListFilteredTransactionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFilteredTransactionEventsResponseFetcher
    implements SyncPageFetcher<ListFilteredTransactionEventsResponse> {
        private ListFilteredTransactionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListFilteredTransactionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFilteredTransactionEventsResponse nextPage(ListFilteredTransactionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListFilteredTransactionEventsIterable.this.client.listFilteredTransactionEvents(ListFilteredTransactionEventsIterable.this.firstRequest);
            }
            return ListFilteredTransactionEventsIterable.this.client.listFilteredTransactionEvents((ListFilteredTransactionEventsRequest)((Object)ListFilteredTransactionEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

