/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem;

public class ListTransactionsIterable
implements SdkIterable<ListTransactionsResponse> {
    private final ManagedBlockchainQueryClient client;
    private final ListTransactionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTransactionsIterable(ManagedBlockchainQueryClient client, ListTransactionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTransactionsResponseFetcher();
    }

    public Iterator<ListTransactionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransactionOutputItem> transactions() {
        Function<ListTransactionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transactions() != null) {
                return response.transactions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTransactionsResponseFetcher
    implements SyncPageFetcher<ListTransactionsResponse> {
        private ListTransactionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTransactionsResponse nextPage(ListTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListTransactionsIterable.this.client.listTransactions(ListTransactionsIterable.this.firstRequest);
            }
            return ListTransactionsIterable.this.client.listTransactions((ListTransactionsRequest)((Object)ListTransactionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

