/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryAsyncClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent;

public class ListTransactionEventsPublisher
implements SdkPublisher<ListTransactionEventsResponse> {
    private final ManagedBlockchainQueryAsyncClient client;
    private final ListTransactionEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTransactionEventsPublisher(ManagedBlockchainQueryAsyncClient client, ListTransactionEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTransactionEventsPublisher(ManagedBlockchainQueryAsyncClient client, ListTransactionEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTransactionEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTransactionEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransactionEvent> events() {
        Function<ListTransactionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTransactionEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTransactionEventsResponseFetcher
    implements AsyncPageFetcher<ListTransactionEventsResponse> {
        private ListTransactionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransactionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTransactionEventsResponse> nextPage(ListTransactionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListTransactionEventsPublisher.this.client.listTransactionEvents(ListTransactionEventsPublisher.this.firstRequest);
            }
            return ListTransactionEventsPublisher.this.client.listTransactionEvents((ListTransactionEventsRequest)((Object)ListTransactionEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

