/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    INVALID_AGREEMENT_ID("INVALID_AGREEMENT_ID"),
    MISSING_AGREEMENT_ID("MISSING_AGREEMENT_ID"),
    INVALID_CATALOG("INVALID_CATALOG"),
    INVALID_FILTER_NAME("INVALID_FILTER_NAME"),
    INVALID_FILTER_VALUES("INVALID_FILTER_VALUES"),
    INVALID_SORT_BY("INVALID_SORT_BY"),
    INVALID_SORT_ORDER("INVALID_SORT_ORDER"),
    INVALID_NEXT_TOKEN("INVALID_NEXT_TOKEN"),
    INVALID_MAX_RESULTS("INVALID_MAX_RESULTS"),
    UNSUPPORTED_FILTERS("UNSUPPORTED_FILTERS"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

