/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.marketplaceagreement.endpoints.MarketplaceAgreementEndpointParams;
import software.amazon.awssdk.services.marketplaceagreement.endpoints.MarketplaceAgreementEndpointProvider;
import software.amazon.awssdk.services.marketplaceagreement.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.marketplaceagreement.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.marketplaceagreement.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultMarketplaceAgreementEndpointProvider
implements MarketplaceAgreementEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(MarketplaceAgreementEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(MarketplaceAgreementEndpointParams params, String region) {
        RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultMarketplaceAgreementEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(MarketplaceAgreementEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultMarketplaceAgreementEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(MarketplaceAgreementEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(MarketplaceAgreementEndpointParams params, String region) {
        RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(MarketplaceAgreementEndpointParams params, String region) {
        if (region != null) {
            return DefaultMarketplaceAgreementEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(MarketplaceAgreementEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule9(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultMarketplaceAgreementEndpointProvider.endpointRule14(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultMarketplaceAgreementEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return DefaultMarketplaceAgreementEndpointProvider.endpointRule24(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(MarketplaceAgreementEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule10(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(MarketplaceAgreementEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return DefaultMarketplaceAgreementEndpointProvider.endpointRule11(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(MarketplaceAgreementEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://agreement-marketplace-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule14(MarketplaceAgreementEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule15(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(MarketplaceAgreementEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return DefaultMarketplaceAgreementEndpointProvider.endpointRule16(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(MarketplaceAgreementEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://agreement-marketplace-fips." + region + "." + partitionResult.dnsSuffix())).build());
    }

    private static RuleResult endpointRule19(MarketplaceAgreementEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMarketplaceAgreementEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(MarketplaceAgreementEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return DefaultMarketplaceAgreementEndpointProvider.endpointRule21(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(MarketplaceAgreementEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://agreement-marketplace." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule24(MarketplaceAgreementEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://agreement-marketplace." + region + "." + partitionResult.dnsSuffix())).build());
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

