/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementClient;
import software.amazon.awssdk.services.marketplaceagreement.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsResponse;

public class GetAgreementTermsIterable
implements SdkIterable<GetAgreementTermsResponse> {
    private final MarketplaceAgreementClient client;
    private final GetAgreementTermsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAgreementTermsIterable(MarketplaceAgreementClient client, GetAgreementTermsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAgreementTermsResponseFetcher();
    }

    public Iterator<GetAgreementTermsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetAgreementTermsResponseFetcher
    implements SyncPageFetcher<GetAgreementTermsResponse> {
        private GetAgreementTermsResponseFetcher() {
        }

        public boolean hasNextPage(GetAgreementTermsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAgreementTermsResponse nextPage(GetAgreementTermsResponse previousPage) {
            if (previousPage == null) {
                return GetAgreementTermsIterable.this.client.getAgreementTerms(GetAgreementTermsIterable.this.firstRequest);
            }
            return GetAgreementTermsIterable.this.client.getAgreementTerms((GetAgreementTermsRequest)((Object)GetAgreementTermsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

