/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementAsyncClient;
import software.amazon.awssdk.services.marketplaceagreement.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsResponse;

public class GetAgreementTermsPublisher
implements SdkPublisher<GetAgreementTermsResponse> {
    private final MarketplaceAgreementAsyncClient client;
    private final GetAgreementTermsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAgreementTermsPublisher(MarketplaceAgreementAsyncClient client, GetAgreementTermsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAgreementTermsPublisher(MarketplaceAgreementAsyncClient client, GetAgreementTermsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAgreementTermsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAgreementTermsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetAgreementTermsResponseFetcher
    implements AsyncPageFetcher<GetAgreementTermsResponse> {
        private GetAgreementTermsResponseFetcher() {
        }

        public boolean hasNextPage(GetAgreementTermsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAgreementTermsResponse> nextPage(GetAgreementTermsResponse previousPage) {
            if (previousPage == null) {
                return GetAgreementTermsPublisher.this.client.getAgreementTerms(GetAgreementTermsPublisher.this.firstRequest);
            }
            return GetAgreementTermsPublisher.this.client.getAgreementTerms((GetAgreementTermsRequest)((Object)GetAgreementTermsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

