/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.marketplaceentitlement.endpoints.MarketplaceEntitlementEndpointParams;
import software.amazon.awssdk.services.marketplaceentitlement.endpoints.MarketplaceEntitlementEndpointProvider;
import software.amazon.awssdk.services.marketplaceentitlement.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.marketplaceentitlement.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.marketplaceentitlement.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultMarketplaceEntitlementEndpointProvider
implements MarketplaceEntitlementEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(MarketplaceEntitlementEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(MarketplaceEntitlementEndpointParams params, String region) {
        RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultMarketplaceEntitlementEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(MarketplaceEntitlementEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultMarketplaceEntitlementEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(MarketplaceEntitlementEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(MarketplaceEntitlementEndpointParams params, String region) {
        RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(MarketplaceEntitlementEndpointParams params, String region) {
        if (region != null) {
            return DefaultMarketplaceEntitlementEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(MarketplaceEntitlementEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement-marketplace." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement-marketplace." + region + ".amazonaws.com.cn")).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement-marketplace." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule12(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule16(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement.marketplace." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(MarketplaceEntitlementEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule13(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(MarketplaceEntitlementEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement.marketplace-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(MarketplaceEntitlementEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule17(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(MarketplaceEntitlementEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement.marketplace-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(MarketplaceEntitlementEndpointParams params, RulePartition partitionResult, String region) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMarketplaceEntitlementEndpointProvider.endpointRule21(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(MarketplaceEntitlementEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://entitlement.marketplace." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

