/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplaceentitlement.model.EntitlementValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entitlement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entitlement> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(Entitlement.getter(Entitlement::productCode)).setter(Entitlement.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dimension").getter(Entitlement.getter(Entitlement::dimension)).setter(Entitlement.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()}).build();
    private static final SdkField<String> CUSTOMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerIdentifier").getter(Entitlement.getter(Entitlement::customerIdentifier)).setter(Entitlement.setter(Builder::customerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerIdentifier").build()}).build();
    private static final SdkField<String> CUSTOMER_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerAWSAccountId").getter(Entitlement.getter(Entitlement::customerAWSAccountId)).setter(Entitlement.setter(Builder::customerAWSAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAWSAccountId").build()}).build();
    private static final SdkField<EntitlementValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(Entitlement.getter(Entitlement::value)).setter(Entitlement.setter(Builder::value)).constructor(EntitlementValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(Entitlement.getter(Entitlement::expirationDate)).setter(Entitlement.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD, DIMENSION_FIELD, CUSTOMER_IDENTIFIER_FIELD, CUSTOMER_AWS_ACCOUNT_ID_FIELD, VALUE_FIELD, EXPIRATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Entitlement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String productCode;
    private final String dimension;
    private final String customerIdentifier;
    private final String customerAWSAccountId;
    private final EntitlementValue value;
    private final Instant expirationDate;

    private Entitlement(BuilderImpl builder) {
        this.productCode = builder.productCode;
        this.dimension = builder.dimension;
        this.customerIdentifier = builder.customerIdentifier;
        this.customerAWSAccountId = builder.customerAWSAccountId;
        this.value = builder.value;
        this.expirationDate = builder.expirationDate;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final String dimension() {
        return this.dimension;
    }

    public final String customerIdentifier() {
        return this.customerIdentifier;
    }

    public final String customerAWSAccountId() {
        return this.customerAWSAccountId;
    }

    public final EntitlementValue value() {
        return this.value;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAWSAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        return Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.customerIdentifier(), other.customerIdentifier()) && Objects.equals(this.customerAWSAccountId(), other.customerAWSAccountId()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.expirationDate(), other.expirationDate());
    }

    public final String toString() {
        return ToString.builder((String)"Entitlement").add("ProductCode", (Object)this.productCode()).add("Dimension", (Object)this.dimension()).add("CustomerIdentifier", (Object)this.customerIdentifier()).add("CustomerAWSAccountId", (Object)this.customerAWSAccountId()).add("Value", (Object)this.value()).add("ExpirationDate", (Object)this.expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "CustomerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customerIdentifier()));
            }
            case "CustomerAWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.customerAWSAccountId()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("Dimension", DIMENSION_FIELD);
        map.put("CustomerIdentifier", CUSTOMER_IDENTIFIER_FIELD);
        map.put("CustomerAWSAccountId", CUSTOMER_AWS_ACCOUNT_ID_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productCode;
        private String dimension;
        private String customerIdentifier;
        private String customerAWSAccountId;
        private EntitlementValue value;
        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            this.productCode(model.productCode);
            this.dimension(model.dimension);
            this.customerIdentifier(model.customerIdentifier);
            this.customerAWSAccountId(model.customerAWSAccountId);
            this.value(model.value);
            this.expirationDate(model.expirationDate);
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getCustomerIdentifier() {
            return this.customerIdentifier;
        }

        public final void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        @Override
        public final Builder customerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
            return this;
        }

        public final String getCustomerAWSAccountId() {
            return this.customerAWSAccountId;
        }

        public final void setCustomerAWSAccountId(String customerAWSAccountId) {
            this.customerAWSAccountId = customerAWSAccountId;
        }

        @Override
        public final Builder customerAWSAccountId(String customerAWSAccountId) {
            this.customerAWSAccountId = customerAWSAccountId;
            return this;
        }

        public final EntitlementValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(EntitlementValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(EntitlementValue value) {
            this.value = value;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Entitlement build() {
            return new Entitlement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entitlement> {
        public Builder productCode(String var1);

        public Builder dimension(String var1);

        public Builder customerIdentifier(String var1);

        public Builder customerAWSAccountId(String var1);

        public Builder value(EntitlementValue var1);

        default public Builder value(Consumer<EntitlementValue.Builder> value) {
            return this.value((EntitlementValue)((EntitlementValue.Builder)EntitlementValue.builder().applyMutation(value)).build());
        }

        public Builder expirationDate(Instant var1);
    }
}

