/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringRequest;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecord;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchMeterUsageRequest
extends MarketplaceMeteringRequest
implements ToCopyableBuilder<Builder, BatchMeterUsageRequest> {
    private static final SdkField<List<UsageRecord>> USAGE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UsageRecords").getter(BatchMeterUsageRequest.getter(BatchMeterUsageRequest::usageRecords)).setter(BatchMeterUsageRequest.setter(Builder::usageRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(BatchMeterUsageRequest.getter(BatchMeterUsageRequest::productCode)).setter(BatchMeterUsageRequest.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_RECORDS_FIELD, PRODUCT_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchMeterUsageRequest.memberNameToFieldInitializer();
    private final List<UsageRecord> usageRecords;
    private final String productCode;

    private BatchMeterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.usageRecords = builder.usageRecords;
        this.productCode = builder.productCode;
    }

    public final boolean hasUsageRecords() {
        return this.usageRecords != null && !(this.usageRecords instanceof SdkAutoConstructList);
    }

    public final List<UsageRecord> usageRecords() {
        return this.usageRecords;
    }

    public final String productCode() {
        return this.productCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageRecords() ? this.usageRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMeterUsageRequest)) {
            return false;
        }
        BatchMeterUsageRequest other = (BatchMeterUsageRequest)((Object)obj);
        return this.hasUsageRecords() == other.hasUsageRecords() && Objects.equals(this.usageRecords(), other.usageRecords()) && Objects.equals(this.productCode(), other.productCode());
    }

    public final String toString() {
        return ToString.builder((String)"BatchMeterUsageRequest").add("UsageRecords", this.hasUsageRecords() ? this.usageRecords() : null).add("ProductCode", (Object)this.productCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageRecords": {
                return Optional.ofNullable(clazz.cast(this.usageRecords()));
            }
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UsageRecords", USAGE_RECORDS_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchMeterUsageRequest, T> g) {
        return obj -> g.apply((BatchMeterUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringRequest.BuilderImpl
    implements Builder {
        private List<UsageRecord> usageRecords = DefaultSdkAutoConstructList.getInstance();
        private String productCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchMeterUsageRequest model) {
            super(model);
            this.usageRecords(model.usageRecords);
            this.productCode(model.productCode);
        }

        public final List<UsageRecord.Builder> getUsageRecords() {
            List<UsageRecord.Builder> result = UsageRecordListCopier.copyToBuilder(this.usageRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageRecords(Collection<UsageRecord.BuilderImpl> usageRecords) {
            this.usageRecords = UsageRecordListCopier.copyFromBuilder(usageRecords);
        }

        @Override
        public final Builder usageRecords(Collection<UsageRecord> usageRecords) {
            this.usageRecords = UsageRecordListCopier.copy(usageRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRecords(UsageRecord ... usageRecords) {
            this.usageRecords(Arrays.asList(usageRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRecords(Consumer<UsageRecord.Builder> ... usageRecords) {
            this.usageRecords(Stream.of(usageRecords).map(c -> (UsageRecord)((UsageRecord.Builder)UsageRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchMeterUsageRequest build() {
            return new BatchMeterUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceMeteringRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchMeterUsageRequest> {
        public Builder usageRecords(Collection<UsageRecord> var1);

        public Builder usageRecords(UsageRecord ... var1);

        public Builder usageRecords(Consumer<UsageRecord.Builder> ... var1);

        public Builder productCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

