/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringRequest;
import software.amazon.awssdk.services.marketplacemetering.model.UsageAllocation;
import software.amazon.awssdk.services.marketplacemetering.model.UsageAllocationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeterUsageRequest
extends MarketplaceMeteringRequest
implements ToCopyableBuilder<Builder, MeterUsageRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(MeterUsageRequest.getter(MeterUsageRequest::productCode)).setter(MeterUsageRequest.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(MeterUsageRequest.getter(MeterUsageRequest::timestamp)).setter(MeterUsageRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> USAGE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageDimension").getter(MeterUsageRequest.getter(MeterUsageRequest::usageDimension)).setter(MeterUsageRequest.setter(Builder::usageDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageDimension").build()}).build();
    private static final SdkField<Integer> USAGE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UsageQuantity").getter(MeterUsageRequest.getter(MeterUsageRequest::usageQuantity)).setter(MeterUsageRequest.setter(Builder::usageQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageQuantity").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(MeterUsageRequest.getter(MeterUsageRequest::dryRun)).setter(MeterUsageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<List<UsageAllocation>> USAGE_ALLOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UsageAllocations").getter(MeterUsageRequest.getter(MeterUsageRequest::usageAllocations)).setter(MeterUsageRequest.setter(Builder::usageAllocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageAllocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(MeterUsageRequest.getter(MeterUsageRequest::clientToken)).setter(MeterUsageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD, TIMESTAMP_FIELD, USAGE_DIMENSION_FIELD, USAGE_QUANTITY_FIELD, DRY_RUN_FIELD, USAGE_ALLOCATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MeterUsageRequest.memberNameToFieldInitializer();
    private final String productCode;
    private final Instant timestamp;
    private final String usageDimension;
    private final Integer usageQuantity;
    private final Boolean dryRun;
    private final List<UsageAllocation> usageAllocations;
    private final String clientToken;

    private MeterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.timestamp = builder.timestamp;
        this.usageDimension = builder.usageDimension;
        this.usageQuantity = builder.usageQuantity;
        this.dryRun = builder.dryRun;
        this.usageAllocations = builder.usageAllocations;
        this.clientToken = builder.clientToken;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String usageDimension() {
        return this.usageDimension;
    }

    public final Integer usageQuantity() {
        return this.usageQuantity;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasUsageAllocations() {
        return this.usageAllocations != null && !(this.usageAllocations instanceof SdkAutoConstructList);
    }

    public final List<UsageAllocation> usageAllocations() {
        return this.usageAllocations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageDimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageAllocations() ? this.usageAllocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeterUsageRequest)) {
            return false;
        }
        MeterUsageRequest other = (MeterUsageRequest)((Object)obj);
        return Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.usageDimension(), other.usageDimension()) && Objects.equals(this.usageQuantity(), other.usageQuantity()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasUsageAllocations() == other.hasUsageAllocations() && Objects.equals(this.usageAllocations(), other.usageAllocations()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"MeterUsageRequest").add("ProductCode", (Object)this.productCode()).add("Timestamp", (Object)this.timestamp()).add("UsageDimension", (Object)this.usageDimension()).add("UsageQuantity", (Object)this.usageQuantity()).add("DryRun", (Object)this.dryRun()).add("UsageAllocations", this.hasUsageAllocations() ? this.usageAllocations() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "UsageDimension": {
                return Optional.ofNullable(clazz.cast(this.usageDimension()));
            }
            case "UsageQuantity": {
                return Optional.ofNullable(clazz.cast(this.usageQuantity()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "UsageAllocations": {
                return Optional.ofNullable(clazz.cast(this.usageAllocations()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("UsageDimension", USAGE_DIMENSION_FIELD);
        map.put("UsageQuantity", USAGE_QUANTITY_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("UsageAllocations", USAGE_ALLOCATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MeterUsageRequest, T> g) {
        return obj -> g.apply((MeterUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringRequest.BuilderImpl
    implements Builder {
        private String productCode;
        private Instant timestamp;
        private String usageDimension;
        private Integer usageQuantity;
        private Boolean dryRun;
        private List<UsageAllocation> usageAllocations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(MeterUsageRequest model) {
            super(model);
            this.productCode(model.productCode);
            this.timestamp(model.timestamp);
            this.usageDimension(model.usageDimension);
            this.usageQuantity(model.usageQuantity);
            this.dryRun(model.dryRun);
            this.usageAllocations(model.usageAllocations);
            this.clientToken(model.clientToken);
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getUsageDimension() {
            return this.usageDimension;
        }

        public final void setUsageDimension(String usageDimension) {
            this.usageDimension = usageDimension;
        }

        @Override
        public final Builder usageDimension(String usageDimension) {
            this.usageDimension = usageDimension;
            return this;
        }

        public final Integer getUsageQuantity() {
            return this.usageQuantity;
        }

        public final void setUsageQuantity(Integer usageQuantity) {
            this.usageQuantity = usageQuantity;
        }

        @Override
        public final Builder usageQuantity(Integer usageQuantity) {
            this.usageQuantity = usageQuantity;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<UsageAllocation.Builder> getUsageAllocations() {
            List<UsageAllocation.Builder> result = UsageAllocationsCopier.copyToBuilder(this.usageAllocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageAllocations(Collection<UsageAllocation.BuilderImpl> usageAllocations) {
            this.usageAllocations = UsageAllocationsCopier.copyFromBuilder(usageAllocations);
        }

        @Override
        public final Builder usageAllocations(Collection<UsageAllocation> usageAllocations) {
            this.usageAllocations = UsageAllocationsCopier.copy(usageAllocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageAllocations(UsageAllocation ... usageAllocations) {
            this.usageAllocations(Arrays.asList(usageAllocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageAllocations(Consumer<UsageAllocation.Builder> ... usageAllocations) {
            this.usageAllocations(Stream.of(usageAllocations).map(c -> (UsageAllocation)((UsageAllocation.Builder)UsageAllocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MeterUsageRequest build() {
            return new MeterUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MarketplaceMeteringRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MeterUsageRequest> {
        public Builder productCode(String var1);

        public Builder timestamp(Instant var1);

        public Builder usageDimension(String var1);

        public Builder usageQuantity(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder usageAllocations(Collection<UsageAllocation> var1);

        public Builder usageAllocations(UsageAllocation ... var1);

        public Builder usageAllocations(Consumer<UsageAllocation.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

