/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.AddMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAddMediaStreamRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddFlowMediaStreamsRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, AddFlowMediaStreamsRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(AddFlowMediaStreamsRequest.getter(AddFlowMediaStreamsRequest::flowArn)).setter(AddFlowMediaStreamsRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FlowArn").build()}).build();
    private static final SdkField<List<AddMediaStreamRequest>> MEDIA_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreams").getter(AddFlowMediaStreamsRequest.getter(AddFlowMediaStreamsRequest::mediaStreams)).setter(AddFlowMediaStreamsRequest.setter(Builder::mediaStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddMediaStreamRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, MEDIA_STREAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddFlowMediaStreamsRequest.memberNameToFieldInitializer();
    private final String flowArn;
    private final List<AddMediaStreamRequest> mediaStreams;

    private AddFlowMediaStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.mediaStreams = builder.mediaStreams;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasMediaStreams() {
        return this.mediaStreams != null && !(this.mediaStreams instanceof SdkAutoConstructList);
    }

    public final List<AddMediaStreamRequest> mediaStreams() {
        return this.mediaStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreams() ? this.mediaStreams() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowMediaStreamsRequest)) {
            return false;
        }
        AddFlowMediaStreamsRequest other = (AddFlowMediaStreamsRequest)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && this.hasMediaStreams() == other.hasMediaStreams() && Objects.equals(this.mediaStreams(), other.mediaStreams());
    }

    public final String toString() {
        return ToString.builder((String)"AddFlowMediaStreamsRequest").add("FlowArn", (Object)this.flowArn()).add("MediaStreams", this.hasMediaStreams() ? this.mediaStreams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MediaStreams": {
                return Optional.ofNullable(clazz.cast(this.mediaStreams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlowArn", FLOW_ARN_FIELD);
        map.put("mediaStreams", MEDIA_STREAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddFlowMediaStreamsRequest, T> g) {
        return obj -> g.apply((AddFlowMediaStreamsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<AddMediaStreamRequest> mediaStreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowMediaStreamsRequest model) {
            super(model);
            this.flowArn(model.flowArn);
            this.mediaStreams(model.mediaStreams);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<AddMediaStreamRequest.Builder> getMediaStreams() {
            List<AddMediaStreamRequest.Builder> result = ___listOfAddMediaStreamRequestCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreams(Collection<AddMediaStreamRequest.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfAddMediaStreamRequestCopier.copyFromBuilder(mediaStreams);
        }

        @Override
        public final Builder mediaStreams(Collection<AddMediaStreamRequest> mediaStreams) {
            this.mediaStreams = ___listOfAddMediaStreamRequestCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(AddMediaStreamRequest ... mediaStreams) {
            this.mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(Consumer<AddMediaStreamRequest.Builder> ... mediaStreams) {
            this.mediaStreams(Stream.of(mediaStreams).map(c -> (AddMediaStreamRequest)((AddMediaStreamRequest.Builder)AddMediaStreamRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddFlowMediaStreamsRequest build() {
            return new AddFlowMediaStreamsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddFlowMediaStreamsRequest> {
        public Builder flowArn(String var1);

        public Builder mediaStreams(Collection<AddMediaStreamRequest> var1);

        public Builder mediaStreams(AddMediaStreamRequest ... var1);

        public Builder mediaStreams(Consumer<AddMediaStreamRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

