/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MulticastSourceSettings;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddBridgeNetworkSourceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddBridgeNetworkSourceRequest> {
    private static final SdkField<String> MULTICAST_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MulticastIp").getter(AddBridgeNetworkSourceRequest.getter(AddBridgeNetworkSourceRequest::multicastIp)).setter(AddBridgeNetworkSourceRequest.setter(Builder::multicastIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastIp").build()}).build();
    private static final SdkField<MulticastSourceSettings> MULTICAST_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MulticastSourceSettings").getter(AddBridgeNetworkSourceRequest.getter(AddBridgeNetworkSourceRequest::multicastSourceSettings)).setter(AddBridgeNetworkSourceRequest.setter(Builder::multicastSourceSettings)).constructor(MulticastSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSourceSettings").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AddBridgeNetworkSourceRequest.getter(AddBridgeNetworkSourceRequest::name)).setter(AddBridgeNetworkSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkName").getter(AddBridgeNetworkSourceRequest.getter(AddBridgeNetworkSourceRequest::networkName)).setter(AddBridgeNetworkSourceRequest.setter(Builder::networkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(AddBridgeNetworkSourceRequest.getter(AddBridgeNetworkSourceRequest::port)).setter(AddBridgeNetworkSourceRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(AddBridgeNetworkSourceRequest.getter(AddBridgeNetworkSourceRequest::protocolAsString)).setter(AddBridgeNetworkSourceRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_IP_FIELD, MULTICAST_SOURCE_SETTINGS_FIELD, NAME_FIELD, NETWORK_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddBridgeNetworkSourceRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String multicastIp;
    private final MulticastSourceSettings multicastSourceSettings;
    private final String name;
    private final String networkName;
    private final Integer port;
    private final String protocol;

    private AddBridgeNetworkSourceRequest(BuilderImpl builder) {
        this.multicastIp = builder.multicastIp;
        this.multicastSourceSettings = builder.multicastSourceSettings;
        this.name = builder.name;
        this.networkName = builder.networkName;
        this.port = builder.port;
        this.protocol = builder.protocol;
    }

    public final String multicastIp() {
        return this.multicastIp;
    }

    public final MulticastSourceSettings multicastSourceSettings() {
        return this.multicastSourceSettings;
    }

    public final String name() {
        return this.name;
    }

    public final String networkName() {
        return this.networkName;
    }

    public final Integer port() {
        return this.port;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeNetworkSourceRequest)) {
            return false;
        }
        AddBridgeNetworkSourceRequest other = (AddBridgeNetworkSourceRequest)obj;
        return Objects.equals(this.multicastIp(), other.multicastIp()) && Objects.equals(this.multicastSourceSettings(), other.multicastSourceSettings()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkName(), other.networkName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AddBridgeNetworkSourceRequest").add("MulticastIp", (Object)this.multicastIp()).add("MulticastSourceSettings", (Object)this.multicastSourceSettings()).add("Name", (Object)this.name()).add("NetworkName", (Object)this.networkName()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MulticastIp": {
                return Optional.ofNullable(clazz.cast(this.multicastIp()));
            }
            case "MulticastSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.multicastSourceSettings()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkName": {
                return Optional.ofNullable(clazz.cast(this.networkName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("multicastIp", MULTICAST_IP_FIELD);
        map.put("multicastSourceSettings", MULTICAST_SOURCE_SETTINGS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkName", NETWORK_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddBridgeNetworkSourceRequest, T> g) {
        return obj -> g.apply((AddBridgeNetworkSourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String multicastIp;
        private MulticastSourceSettings multicastSourceSettings;
        private String name;
        private String networkName;
        private Integer port;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(AddBridgeNetworkSourceRequest model) {
            this.multicastIp(model.multicastIp);
            this.multicastSourceSettings(model.multicastSourceSettings);
            this.name(model.name);
            this.networkName(model.networkName);
            this.port(model.port);
            this.protocol(model.protocol);
        }

        public final String getMulticastIp() {
            return this.multicastIp;
        }

        public final void setMulticastIp(String multicastIp) {
            this.multicastIp = multicastIp;
        }

        @Override
        public final Builder multicastIp(String multicastIp) {
            this.multicastIp = multicastIp;
            return this;
        }

        public final MulticastSourceSettings.Builder getMulticastSourceSettings() {
            return this.multicastSourceSettings != null ? this.multicastSourceSettings.toBuilder() : null;
        }

        public final void setMulticastSourceSettings(MulticastSourceSettings.BuilderImpl multicastSourceSettings) {
            this.multicastSourceSettings = multicastSourceSettings != null ? multicastSourceSettings.build() : null;
        }

        @Override
        public final Builder multicastSourceSettings(MulticastSourceSettings multicastSourceSettings) {
            this.multicastSourceSettings = multicastSourceSettings;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkName() {
            return this.networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public AddBridgeNetworkSourceRequest build() {
            return new AddBridgeNetworkSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddBridgeNetworkSourceRequest> {
        public Builder multicastIp(String var1);

        public Builder multicastSourceSettings(MulticastSourceSettings var1);

        default public Builder multicastSourceSettings(Consumer<MulticastSourceSettings.Builder> multicastSourceSettings) {
            return this.multicastSourceSettings((MulticastSourceSettings)((MulticastSourceSettings.Builder)MulticastSourceSettings.builder().applyMutation(multicastSourceSettings)).build());
        }

        public Builder name(String var1);

        public Builder networkName(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);
    }
}

