/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.AudioMonitoringSetting;
import software.amazon.awssdk.services.mediaconnect.model.ContentQualityAnalysisState;
import software.amazon.awssdk.services.mediaconnect.model.ThumbnailState;
import software.amazon.awssdk.services.mediaconnect.model.VideoMonitoringSetting;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAudioMonitoringSettingCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfVideoMonitoringSettingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringConfig> {
    private static final SdkField<String> THUMBNAIL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThumbnailState").getter(MonitoringConfig.getter(MonitoringConfig::thumbnailStateAsString)).setter(MonitoringConfig.setter(Builder::thumbnailState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailState").build()}).build();
    private static final SdkField<List<AudioMonitoringSetting>> AUDIO_MONITORING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioMonitoringSettings").getter(MonitoringConfig.getter(MonitoringConfig::audioMonitoringSettings)).setter(MonitoringConfig.setter(Builder::audioMonitoringSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioMonitoringSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioMonitoringSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_QUALITY_ANALYSIS_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentQualityAnalysisState").getter(MonitoringConfig.getter(MonitoringConfig::contentQualityAnalysisStateAsString)).setter(MonitoringConfig.setter(Builder::contentQualityAnalysisState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentQualityAnalysisState").build()}).build();
    private static final SdkField<List<VideoMonitoringSetting>> VIDEO_MONITORING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VideoMonitoringSettings").getter(MonitoringConfig.getter(MonitoringConfig::videoMonitoringSettings)).setter(MonitoringConfig.setter(Builder::videoMonitoringSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoMonitoringSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoMonitoringSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBNAIL_STATE_FIELD, AUDIO_MONITORING_SETTINGS_FIELD, CONTENT_QUALITY_ANALYSIS_STATE_FIELD, VIDEO_MONITORING_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitoringConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String thumbnailState;
    private final List<AudioMonitoringSetting> audioMonitoringSettings;
    private final String contentQualityAnalysisState;
    private final List<VideoMonitoringSetting> videoMonitoringSettings;

    private MonitoringConfig(BuilderImpl builder) {
        this.thumbnailState = builder.thumbnailState;
        this.audioMonitoringSettings = builder.audioMonitoringSettings;
        this.contentQualityAnalysisState = builder.contentQualityAnalysisState;
        this.videoMonitoringSettings = builder.videoMonitoringSettings;
    }

    public final ThumbnailState thumbnailState() {
        return ThumbnailState.fromValue(this.thumbnailState);
    }

    public final String thumbnailStateAsString() {
        return this.thumbnailState;
    }

    public final boolean hasAudioMonitoringSettings() {
        return this.audioMonitoringSettings != null && !(this.audioMonitoringSettings instanceof SdkAutoConstructList);
    }

    public final List<AudioMonitoringSetting> audioMonitoringSettings() {
        return this.audioMonitoringSettings;
    }

    public final ContentQualityAnalysisState contentQualityAnalysisState() {
        return ContentQualityAnalysisState.fromValue(this.contentQualityAnalysisState);
    }

    public final String contentQualityAnalysisStateAsString() {
        return this.contentQualityAnalysisState;
    }

    public final boolean hasVideoMonitoringSettings() {
        return this.videoMonitoringSettings != null && !(this.videoMonitoringSettings instanceof SdkAutoConstructList);
    }

    public final List<VideoMonitoringSetting> videoMonitoringSettings() {
        return this.videoMonitoringSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioMonitoringSettings() ? this.audioMonitoringSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentQualityAnalysisStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVideoMonitoringSettings() ? this.videoMonitoringSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfig)) {
            return false;
        }
        MonitoringConfig other = (MonitoringConfig)obj;
        return Objects.equals(this.thumbnailStateAsString(), other.thumbnailStateAsString()) && this.hasAudioMonitoringSettings() == other.hasAudioMonitoringSettings() && Objects.equals(this.audioMonitoringSettings(), other.audioMonitoringSettings()) && Objects.equals(this.contentQualityAnalysisStateAsString(), other.contentQualityAnalysisStateAsString()) && this.hasVideoMonitoringSettings() == other.hasVideoMonitoringSettings() && Objects.equals(this.videoMonitoringSettings(), other.videoMonitoringSettings());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringConfig").add("ThumbnailState", (Object)this.thumbnailStateAsString()).add("AudioMonitoringSettings", this.hasAudioMonitoringSettings() ? this.audioMonitoringSettings() : null).add("ContentQualityAnalysisState", (Object)this.contentQualityAnalysisStateAsString()).add("VideoMonitoringSettings", this.hasVideoMonitoringSettings() ? this.videoMonitoringSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThumbnailState": {
                return Optional.ofNullable(clazz.cast(this.thumbnailStateAsString()));
            }
            case "AudioMonitoringSettings": {
                return Optional.ofNullable(clazz.cast(this.audioMonitoringSettings()));
            }
            case "ContentQualityAnalysisState": {
                return Optional.ofNullable(clazz.cast(this.contentQualityAnalysisStateAsString()));
            }
            case "VideoMonitoringSettings": {
                return Optional.ofNullable(clazz.cast(this.videoMonitoringSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thumbnailState", THUMBNAIL_STATE_FIELD);
        map.put("audioMonitoringSettings", AUDIO_MONITORING_SETTINGS_FIELD);
        map.put("contentQualityAnalysisState", CONTENT_QUALITY_ANALYSIS_STATE_FIELD);
        map.put("videoMonitoringSettings", VIDEO_MONITORING_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfig, T> g) {
        return obj -> g.apply((MonitoringConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thumbnailState;
        private List<AudioMonitoringSetting> audioMonitoringSettings = DefaultSdkAutoConstructList.getInstance();
        private String contentQualityAnalysisState;
        private List<VideoMonitoringSetting> videoMonitoringSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfig model) {
            this.thumbnailState(model.thumbnailState);
            this.audioMonitoringSettings(model.audioMonitoringSettings);
            this.contentQualityAnalysisState(model.contentQualityAnalysisState);
            this.videoMonitoringSettings(model.videoMonitoringSettings);
        }

        public final String getThumbnailState() {
            return this.thumbnailState;
        }

        public final void setThumbnailState(String thumbnailState) {
            this.thumbnailState = thumbnailState;
        }

        @Override
        public final Builder thumbnailState(String thumbnailState) {
            this.thumbnailState = thumbnailState;
            return this;
        }

        @Override
        public final Builder thumbnailState(ThumbnailState thumbnailState) {
            this.thumbnailState(thumbnailState == null ? null : thumbnailState.toString());
            return this;
        }

        public final List<AudioMonitoringSetting.Builder> getAudioMonitoringSettings() {
            List<AudioMonitoringSetting.Builder> result = ___listOfAudioMonitoringSettingCopier.copyToBuilder(this.audioMonitoringSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioMonitoringSettings(Collection<AudioMonitoringSetting.BuilderImpl> audioMonitoringSettings) {
            this.audioMonitoringSettings = ___listOfAudioMonitoringSettingCopier.copyFromBuilder(audioMonitoringSettings);
        }

        @Override
        public final Builder audioMonitoringSettings(Collection<AudioMonitoringSetting> audioMonitoringSettings) {
            this.audioMonitoringSettings = ___listOfAudioMonitoringSettingCopier.copy(audioMonitoringSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMonitoringSettings(AudioMonitoringSetting ... audioMonitoringSettings) {
            this.audioMonitoringSettings(Arrays.asList(audioMonitoringSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMonitoringSettings(Consumer<AudioMonitoringSetting.Builder> ... audioMonitoringSettings) {
            this.audioMonitoringSettings(Stream.of(audioMonitoringSettings).map(c -> (AudioMonitoringSetting)((AudioMonitoringSetting.Builder)AudioMonitoringSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContentQualityAnalysisState() {
            return this.contentQualityAnalysisState;
        }

        public final void setContentQualityAnalysisState(String contentQualityAnalysisState) {
            this.contentQualityAnalysisState = contentQualityAnalysisState;
        }

        @Override
        public final Builder contentQualityAnalysisState(String contentQualityAnalysisState) {
            this.contentQualityAnalysisState = contentQualityAnalysisState;
            return this;
        }

        @Override
        public final Builder contentQualityAnalysisState(ContentQualityAnalysisState contentQualityAnalysisState) {
            this.contentQualityAnalysisState(contentQualityAnalysisState == null ? null : contentQualityAnalysisState.toString());
            return this;
        }

        public final List<VideoMonitoringSetting.Builder> getVideoMonitoringSettings() {
            List<VideoMonitoringSetting.Builder> result = ___listOfVideoMonitoringSettingCopier.copyToBuilder(this.videoMonitoringSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideoMonitoringSettings(Collection<VideoMonitoringSetting.BuilderImpl> videoMonitoringSettings) {
            this.videoMonitoringSettings = ___listOfVideoMonitoringSettingCopier.copyFromBuilder(videoMonitoringSettings);
        }

        @Override
        public final Builder videoMonitoringSettings(Collection<VideoMonitoringSetting> videoMonitoringSettings) {
            this.videoMonitoringSettings = ___listOfVideoMonitoringSettingCopier.copy(videoMonitoringSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMonitoringSettings(VideoMonitoringSetting ... videoMonitoringSettings) {
            this.videoMonitoringSettings(Arrays.asList(videoMonitoringSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMonitoringSettings(Consumer<VideoMonitoringSetting.Builder> ... videoMonitoringSettings) {
            this.videoMonitoringSettings(Stream.of(videoMonitoringSettings).map(c -> (VideoMonitoringSetting)((VideoMonitoringSetting.Builder)VideoMonitoringSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MonitoringConfig build() {
            return new MonitoringConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringConfig> {
        public Builder thumbnailState(String var1);

        public Builder thumbnailState(ThumbnailState var1);

        public Builder audioMonitoringSettings(Collection<AudioMonitoringSetting> var1);

        public Builder audioMonitoringSettings(AudioMonitoringSetting ... var1);

        public Builder audioMonitoringSettings(Consumer<AudioMonitoringSetting.Builder> ... var1);

        public Builder contentQualityAnalysisState(String var1);

        public Builder contentQualityAnalysisState(ContentQualityAnalysisState var1);

        public Builder videoMonitoringSettings(Collection<VideoMonitoringSetting> var1);

        public Builder videoMonitoringSettings(VideoMonitoringSetting ... var1);

        public Builder videoMonitoringSettings(Consumer<VideoMonitoringSetting.Builder> ... var1);
    }
}

