/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RistRouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RtpRouterInputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeRouterInputProtocolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MergeRouterInputProtocolConfiguration> {
    private static final SdkField<RtpRouterInputConfiguration> RTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rtp").getter(MergeRouterInputProtocolConfiguration.getter(MergeRouterInputProtocolConfiguration::rtp)).setter(MergeRouterInputProtocolConfiguration.setter(Builder::rtp)).constructor(RtpRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtp").build()}).build();
    private static final SdkField<RistRouterInputConfiguration> RIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rist").getter(MergeRouterInputProtocolConfiguration.getter(MergeRouterInputProtocolConfiguration::rist)).setter(MergeRouterInputProtocolConfiguration.setter(Builder::rist)).constructor(RistRouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rist").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RTP_FIELD, RIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MergeRouterInputProtocolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RtpRouterInputConfiguration rtp;
    private final RistRouterInputConfiguration rist;
    private final Type type;

    private MergeRouterInputProtocolConfiguration(BuilderImpl builder) {
        this.rtp = builder.rtp;
        this.rist = builder.rist;
        this.type = builder.type;
    }

    public final RtpRouterInputConfiguration rtp() {
        return this.rtp;
    }

    public final RistRouterInputConfiguration rist() {
        return this.rist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rtp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rist());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeRouterInputProtocolConfiguration)) {
            return false;
        }
        MergeRouterInputProtocolConfiguration other = (MergeRouterInputProtocolConfiguration)obj;
        return Objects.equals(this.rtp(), other.rtp()) && Objects.equals(this.rist(), other.rist());
    }

    public final String toString() {
        return ToString.builder((String)"MergeRouterInputProtocolConfiguration").add("Rtp", (Object)this.rtp()).add("Rist", (Object)this.rist()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rtp": {
                return Optional.ofNullable(clazz.cast(this.rtp()));
            }
            case "Rist": {
                return Optional.ofNullable(clazz.cast(this.rist()));
            }
        }
        return Optional.empty();
    }

    public static MergeRouterInputProtocolConfiguration fromRtp(RtpRouterInputConfiguration rtp) {
        return (MergeRouterInputProtocolConfiguration)MergeRouterInputProtocolConfiguration.builder().rtp(rtp).build();
    }

    public static MergeRouterInputProtocolConfiguration fromRtp(Consumer<RtpRouterInputConfiguration.Builder> rtp) {
        RtpRouterInputConfiguration.Builder builder = RtpRouterInputConfiguration.builder();
        rtp.accept(builder);
        return MergeRouterInputProtocolConfiguration.fromRtp((RtpRouterInputConfiguration)builder.build());
    }

    public static MergeRouterInputProtocolConfiguration fromRist(RistRouterInputConfiguration rist) {
        return (MergeRouterInputProtocolConfiguration)MergeRouterInputProtocolConfiguration.builder().rist(rist).build();
    }

    public static MergeRouterInputProtocolConfiguration fromRist(Consumer<RistRouterInputConfiguration.Builder> rist) {
        RistRouterInputConfiguration.Builder builder = RistRouterInputConfiguration.builder();
        rist.accept(builder);
        return MergeRouterInputProtocolConfiguration.fromRist((RistRouterInputConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rtp", RTP_FIELD);
        map.put("rist", RIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeRouterInputProtocolConfiguration, T> g) {
        return obj -> g.apply((MergeRouterInputProtocolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RTP,
        RIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RtpRouterInputConfiguration rtp;
        private RistRouterInputConfiguration rist;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MergeRouterInputProtocolConfiguration model) {
            this.rtp(model.rtp);
            this.rist(model.rist);
        }

        public final RtpRouterInputConfiguration.Builder getRtp() {
            return this.rtp != null ? this.rtp.toBuilder() : null;
        }

        public final void setRtp(RtpRouterInputConfiguration.BuilderImpl rtp) {
            RtpRouterInputConfiguration oldValue = this.rtp;
            this.rtp = rtp != null ? rtp.build() : null;
            this.handleUnionValueChange(Type.RTP, oldValue, this.rtp);
        }

        @Override
        public final Builder rtp(RtpRouterInputConfiguration rtp) {
            RtpRouterInputConfiguration oldValue = this.rtp;
            this.rtp = rtp;
            this.handleUnionValueChange(Type.RTP, oldValue, this.rtp);
            return this;
        }

        public final RistRouterInputConfiguration.Builder getRist() {
            return this.rist != null ? this.rist.toBuilder() : null;
        }

        public final void setRist(RistRouterInputConfiguration.BuilderImpl rist) {
            RistRouterInputConfiguration oldValue = this.rist;
            this.rist = rist != null ? rist.build() : null;
            this.handleUnionValueChange(Type.RIST, oldValue, this.rist);
        }

        @Override
        public final Builder rist(RistRouterInputConfiguration rist) {
            RistRouterInputConfiguration oldValue = this.rist;
            this.rist = rist;
            this.handleUnionValueChange(Type.RIST, oldValue, this.rist);
            return this;
        }

        public MergeRouterInputProtocolConfiguration build() {
            return new MergeRouterInputProtocolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MergeRouterInputProtocolConfiguration> {
        public Builder rtp(RtpRouterInputConfiguration var1);

        default public Builder rtp(Consumer<RtpRouterInputConfiguration.Builder> rtp) {
            return this.rtp((RtpRouterInputConfiguration)((RtpRouterInputConfiguration.Builder)RtpRouterInputConfiguration.builder().applyMutation(rtp)).build());
        }

        public Builder rist(RistRouterInputConfiguration var1);

        default public Builder rist(Consumer<RistRouterInputConfiguration.Builder> rist) {
            return this.rist((RistRouterInputConfiguration)((RistRouterInputConfiguration.Builder)RistRouterInputConfiguration.builder().applyMutation(rist)).build());
        }
    }
}

