/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouterInputState {
    CREATING("CREATING"),
    STANDBY("STANDBY"),
    STARTING("STARTING"),
    ACTIVE("ACTIVE"),
    STOPPING("STOPPING"),
    DELETING("DELETING"),
    UPDATING("UPDATING"),
    ERROR("ERROR"),
    RECOVERING("RECOVERING"),
    MIGRATING("MIGRATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouterInputState> VALUE_MAP;
    private final String value;

    private RouterInputState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouterInputState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouterInputState> knownValues() {
        EnumSet<RouterInputState> knownValues = EnumSet.allOf(RouterInputState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouterInputState.class, RouterInputState::toString);
    }
}

