/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterNetworkInterface;

public class ListRouterNetworkInterfacesIterable
implements SdkIterable<ListRouterNetworkInterfacesResponse> {
    private final MediaConnectClient client;
    private final ListRouterNetworkInterfacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRouterNetworkInterfacesIterable(MediaConnectClient client, ListRouterNetworkInterfacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRouterNetworkInterfacesResponseFetcher();
    }

    public Iterator<ListRouterNetworkInterfacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedRouterNetworkInterface> routerNetworkInterfaces() {
        Function<ListRouterNetworkInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routerNetworkInterfaces() != null) {
                return response.routerNetworkInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRouterNetworkInterfacesResponseFetcher
    implements SyncPageFetcher<ListRouterNetworkInterfacesResponse> {
        private ListRouterNetworkInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(ListRouterNetworkInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRouterNetworkInterfacesResponse nextPage(ListRouterNetworkInterfacesResponse previousPage) {
            if (previousPage == null) {
                return ListRouterNetworkInterfacesIterable.this.client.listRouterNetworkInterfaces(ListRouterNetworkInterfacesIterable.this.firstRequest);
            }
            return ListRouterNetworkInterfacesIterable.this.client.listRouterNetworkInterfaces((ListRouterNetworkInterfacesRequest)((Object)ListRouterNetworkInterfacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

