/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.PublicRouterNetworkInterfaceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.VpcRouterNetworkInterfaceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterNetworkInterfaceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterNetworkInterfaceConfiguration> {
    private static final SdkField<PublicRouterNetworkInterfaceConfiguration> PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Public").getter(RouterNetworkInterfaceConfiguration.getter(RouterNetworkInterfaceConfiguration::publicValue)).setter(RouterNetworkInterfaceConfiguration.setter(Builder::publicValue)).constructor(PublicRouterNetworkInterfaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("public").build()}).build();
    private static final SdkField<VpcRouterNetworkInterfaceConfiguration> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(RouterNetworkInterfaceConfiguration.getter(RouterNetworkInterfaceConfiguration::vpc)).setter(RouterNetworkInterfaceConfiguration.setter(Builder::vpc)).constructor(VpcRouterNetworkInterfaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_FIELD, VPC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterNetworkInterfaceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PublicRouterNetworkInterfaceConfiguration publicValue;
    private final VpcRouterNetworkInterfaceConfiguration vpc;
    private final Type type;

    private RouterNetworkInterfaceConfiguration(BuilderImpl builder) {
        this.publicValue = builder.publicValue;
        this.vpc = builder.vpc;
        this.type = builder.type;
    }

    public final PublicRouterNetworkInterfaceConfiguration publicValue() {
        return this.publicValue;
    }

    public final VpcRouterNetworkInterfaceConfiguration vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterNetworkInterfaceConfiguration)) {
            return false;
        }
        RouterNetworkInterfaceConfiguration other = (RouterNetworkInterfaceConfiguration)obj;
        return Objects.equals(this.publicValue(), other.publicValue()) && Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"RouterNetworkInterfaceConfiguration").add("Public", (Object)this.publicValue()).add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Public": {
                return Optional.ofNullable(clazz.cast(this.publicValue()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public static RouterNetworkInterfaceConfiguration fromPublicValue(PublicRouterNetworkInterfaceConfiguration publicValue) {
        return (RouterNetworkInterfaceConfiguration)RouterNetworkInterfaceConfiguration.builder().publicValue(publicValue).build();
    }

    public static RouterNetworkInterfaceConfiguration fromPublicValue(Consumer<PublicRouterNetworkInterfaceConfiguration.Builder> publicValue) {
        PublicRouterNetworkInterfaceConfiguration.Builder builder = PublicRouterNetworkInterfaceConfiguration.builder();
        publicValue.accept(builder);
        return RouterNetworkInterfaceConfiguration.fromPublicValue((PublicRouterNetworkInterfaceConfiguration)builder.build());
    }

    public static RouterNetworkInterfaceConfiguration fromVpc(VpcRouterNetworkInterfaceConfiguration vpc) {
        return (RouterNetworkInterfaceConfiguration)RouterNetworkInterfaceConfiguration.builder().vpc(vpc).build();
    }

    public static RouterNetworkInterfaceConfiguration fromVpc(Consumer<VpcRouterNetworkInterfaceConfiguration.Builder> vpc) {
        VpcRouterNetworkInterfaceConfiguration.Builder builder = VpcRouterNetworkInterfaceConfiguration.builder();
        vpc.accept(builder);
        return RouterNetworkInterfaceConfiguration.fromVpc((VpcRouterNetworkInterfaceConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("public", PUBLIC_FIELD);
        map.put("vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterNetworkInterfaceConfiguration, T> g) {
        return obj -> g.apply((RouterNetworkInterfaceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PUBLIC,
        VPC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PublicRouterNetworkInterfaceConfiguration publicValue;
        private VpcRouterNetworkInterfaceConfiguration vpc;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterNetworkInterfaceConfiguration model) {
            this.publicValue(model.publicValue);
            this.vpc(model.vpc);
        }

        public final PublicRouterNetworkInterfaceConfiguration.Builder getPublicValue() {
            return this.publicValue != null ? this.publicValue.toBuilder() : null;
        }

        public final void setPublicValue(PublicRouterNetworkInterfaceConfiguration.BuilderImpl publicValue) {
            PublicRouterNetworkInterfaceConfiguration oldValue = this.publicValue;
            this.publicValue = publicValue != null ? publicValue.build() : null;
            this.handleUnionValueChange(Type.PUBLIC, oldValue, this.publicValue);
        }

        @Override
        public final Builder publicValue(PublicRouterNetworkInterfaceConfiguration publicValue) {
            PublicRouterNetworkInterfaceConfiguration oldValue = this.publicValue;
            this.publicValue = publicValue;
            this.handleUnionValueChange(Type.PUBLIC, oldValue, this.publicValue);
            return this;
        }

        public final VpcRouterNetworkInterfaceConfiguration.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(VpcRouterNetworkInterfaceConfiguration.BuilderImpl vpc) {
            VpcRouterNetworkInterfaceConfiguration oldValue = this.vpc;
            this.vpc = vpc != null ? vpc.build() : null;
            this.handleUnionValueChange(Type.VPC, oldValue, this.vpc);
        }

        @Override
        public final Builder vpc(VpcRouterNetworkInterfaceConfiguration vpc) {
            VpcRouterNetworkInterfaceConfiguration oldValue = this.vpc;
            this.vpc = vpc;
            this.handleUnionValueChange(Type.VPC, oldValue, this.vpc);
            return this;
        }

        public RouterNetworkInterfaceConfiguration build() {
            return new RouterNetworkInterfaceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterNetworkInterfaceConfiguration> {
        public Builder publicValue(PublicRouterNetworkInterfaceConfiguration var1);

        default public Builder publicValue(Consumer<PublicRouterNetworkInterfaceConfiguration.Builder> publicValue) {
            return this.publicValue((PublicRouterNetworkInterfaceConfiguration)((PublicRouterNetworkInterfaceConfiguration.Builder)PublicRouterNetworkInterfaceConfiguration.builder().applyMutation(publicValue)).build());
        }

        public Builder vpc(VpcRouterNetworkInterfaceConfiguration var1);

        default public Builder vpc(Consumer<VpcRouterNetworkInterfaceConfiguration.Builder> vpc) {
            return this.vpc((VpcRouterNetworkInterfaceConfiguration)((VpcRouterNetworkInterfaceConfiguration.Builder)VpcRouterNetworkInterfaceConfiguration.builder().applyMutation(vpc)).build());
        }
    }
}

